/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration.commands;

import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.migration.TypeConverter;
import org.dizitart.no2.migration.commands.BaseCommand;

public class ChangeDataType
extends BaseCommand {
    private final String collectionName;
    private final String fieldName;
    private final TypeConverter typeConverter;

    @Override
    public void execute(Nitrite nitrite) {
        this.initialize(nitrite, this.collectionName);
        for (Pair pair : this.nitriteMap.entries()) {
            Document document = (Document)pair.getSecond();
            Object value = document.get(this.fieldName);
            Object newValue = this.typeConverter.convert(value);
            document.put(this.fieldName, newValue);
            this.nitriteMap.put((NitriteId)pair.getFirst(), document);
        }
        IndexDescriptor indexDescriptor = this.operations.findIndex(Fields.withNames(this.fieldName));
        if (indexDescriptor != null) {
            this.operations.rebuildIndex(indexDescriptor);
        }
    }

    @Generated
    public ChangeDataType(String collectionName, String fieldName, TypeConverter typeConverter) {
        this.collectionName = collectionName;
        this.fieldName = fieldName;
        this.typeConverter = typeConverter;
    }
}

