/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.EntityId;
import org.dizitart.no2.repository.EntityIndex;
import org.dizitart.no2.repository.IndexValidator;
import org.dizitart.no2.repository.ObjectIdField;
import org.dizitart.no2.repository.Reflector;

public class EntityDecoratorScanner {
    private final EntityDecorator<?> entityDecorator;
    private final NitriteCollection collection;
    private final NitriteMapper nitriteMapper;
    private final IndexValidator indexValidator;
    private final Reflector reflector;
    private final Set<EntityIndex> indices;
    private ObjectIdField objectIdField;

    public EntityDecoratorScanner(EntityDecorator<?> entityDecorator, NitriteCollection collection, NitriteMapper nitriteMapper) {
        this.entityDecorator = entityDecorator;
        this.collection = collection;
        this.nitriteMapper = nitriteMapper;
        this.indices = new HashSet<EntityIndex>();
        this.indexValidator = new IndexValidator();
        this.reflector = new Reflector();
    }

    public void readEntity() {
        this.readIndices();
        this.readIdField();
    }

    public void createIndices() {
        for (EntityIndex index : this.indices) {
            String[] fields = index.getFieldNames().toArray(new String[0]);
            this.collection.createIndex(IndexOptions.indexOptions(index.getIndexType()), fields);
        }
    }

    public void createIdIndex() {
        if (this.objectIdField != null) {
            String[] fieldNames = this.objectIdField.getEmbeddedFieldNames();
            this.collection.createIndex(fieldNames);
        }
    }

    private void readIndices() {
        if (this.entityDecorator.getIndexFields() != null) {
            for (EntityIndex indexField : this.entityDecorator.getIndexFields()) {
                List<String> names = indexField.getFieldNames();
                ArrayList<Field> entityFields = new ArrayList<Field>();
                for (String name : names) {
                    Field field = this.reflector.getField(this.entityDecorator.getEntityType(), name);
                    if (field == null) continue;
                    entityFields.add(field);
                    this.indexValidator.validate(field.getType(), field.getName(), this.nitriteMapper);
                }
                if (entityFields.size() != names.size()) continue;
                this.indices.add(indexField);
            }
        }
    }

    private void readIdField() {
        String idFieldName;
        EntityId entityId;
        if (this.entityDecorator != null && (entityId = this.entityDecorator.getIdField()) != null && !StringUtils.isNullOrEmpty(idFieldName = entityId.getFieldName())) {
            Field field = this.reflector.getField(this.entityDecorator.getEntityType(), idFieldName);
            this.indexValidator.validateId(entityId, field.getType(), idFieldName, this.nitriteMapper);
            this.objectIdField = new ObjectIdField();
            this.objectIdField.setField(field);
            this.objectIdField.setIdFieldName(idFieldName);
            this.objectIdField.setEmbedded(entityId.isEmbedded());
            this.objectIdField.setFieldNames(entityId.getEmbeddedFields());
        }
    }

    @Generated
    Set<EntityIndex> getIndices() {
        return this.indices;
    }

    @Generated
    public ObjectIdField getObjectIdField() {
        return this.objectIdField;
    }
}

