/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.repository.annotations.InheritIndices;

class Reflector {
    Reflector() {
    }

    public <T extends Annotation> List<T> findInheritedAnnotations(Class<T> annotation, Class<?> type) {
        Class<?>[] interfaces;
        ValidationUtils.notNull(type, "type cannot be null");
        ValidationUtils.notNull(annotation, "annotationClass cannot be null");
        ArrayList<T> annotations = new ArrayList<T>();
        T t = type.getAnnotation(annotation);
        if (t != null) {
            annotations.add(t);
        }
        for (Class<?> anInterface : interfaces = type.getInterfaces()) {
            T ann = anInterface.getAnnotation(annotation);
            if (ann == null) continue;
            annotations.add(ann);
        }
        Class<?> parentClass = type.getSuperclass();
        if (parentClass != null && !parentClass.equals(Object.class)) {
            List<T> list = this.findInheritedAnnotations(annotation, parentClass);
            annotations.addAll(list);
        }
        return annotations;
    }

    public <T> Field getEmbeddedField(Class<T> startingClass, String embeddedField) {
        Field field;
        String remaining;
        String regex = MessageFormat.format("\\{0}", NitriteConfig.getFieldSeparator());
        String[] split = embeddedField.split(regex, 2);
        String key = split[0];
        String string = remaining = split.length == 2 ? split[1] : "";
        if (StringUtils.isNullOrEmpty(key)) {
            throw new ValidationException("Invalid embedded field provided");
        }
        try {
            field = startingClass.getDeclaredField(key);
        }
        catch (NoSuchFieldException e) {
            throw new ValidationException("No such field '" + key + "' for type " + startingClass.getName(), e);
        }
        if (!StringUtils.isNullOrEmpty(remaining) || remaining.contains(NitriteConfig.getFieldSeparator())) {
            return this.getEmbeddedField(field.getType(), remaining);
        }
        return field;
    }

    public List<Field> getFieldsUpto(Class<?> startClass, Class<?> exclusiveParent) {
        ValidationUtils.notNull(startClass, "startClass cannot be null");
        ArrayList<Field> currentClassFields = new ArrayList<Field>(Arrays.asList(startClass.getDeclaredFields()));
        this.filterSynthetics(currentClassFields);
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(exclusiveParent)) {
            List<Field> parentClassFields = this.getFieldsUpto(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public <T> Field getField(Class<T> type, String name) {
        if (name.contains(NitriteConfig.getFieldSeparator())) {
            return this.getEmbeddedField(type, name);
        }
        Field[] declaredFields = type.getDeclaredFields();
        Field field = null;
        for (Field declaredField : declaredFields) {
            if (!declaredField.getName().equals(name)) continue;
            field = declaredField;
            break;
        }
        if (field == null) {
            List<Field> fields = this.getFieldsUpto(type, Object.class);
            for (Field recursiveField : fields) {
                if (!recursiveField.getName().equals(name)) continue;
                field = recursiveField;
                break;
            }
        }
        if (field == null) {
            throw new ValidationException("No such field '" + name + "' for type " + type.getName());
        }
        return field;
    }

    public <T> List<Field> getAllFields(Class<T> type) {
        List<Field> fields = type.isAnnotationPresent(InheritIndices.class) ? this.getFieldsUpto(type, Object.class) : Arrays.asList(type.getDeclaredFields());
        return fields;
    }

    private void filterSynthetics(List<Field> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Iterator<Field> iterator = fields.iterator();
        if (iterator.hasNext()) {
            do {
                Field f;
                if (!(f = iterator.next()).isSynthetic()) continue;
                iterator.remove();
            } while (iterator.hasNext());
        }
    }
}

