/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.concurrent.LockService;
import org.dizitart.no2.common.module.NitriteModule;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.exceptions.TransactionException;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.transaction.Command;
import org.dizitart.no2.transaction.DefaultTransactionalCollection;
import org.dizitart.no2.transaction.DefaultTransactionalRepository;
import org.dizitart.no2.transaction.JournalEntry;
import org.dizitart.no2.transaction.Transaction;
import org.dizitart.no2.transaction.TransactionConfig;
import org.dizitart.no2.transaction.TransactionContext;
import org.dizitart.no2.transaction.TransactionState;
import org.dizitart.no2.transaction.TransactionStore;
import org.dizitart.no2.transaction.UndoEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NitriteTransaction
implements Transaction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private final Nitrite nitrite;
    private final LockService lockService;
    private TransactionStore<?> transactionStore;
    private TransactionConfig transactionConfig;
    private Map<String, TransactionContext> contextMap;
    private Map<String, NitriteCollection> collectionRegistry;
    private Map<String, ObjectRepository<?>> repositoryRegistry;
    private Map<String, Stack<UndoEntry>> undoRegistry;
    private String id;
    private TransactionState state;

    public NitriteTransaction(Nitrite nitrite, LockService lockService) {
        this.nitrite = nitrite;
        this.lockService = lockService;
        this.prepare();
    }

    @Override
    public synchronized NitriteCollection getCollection(String name) {
        this.checkState();
        if (this.collectionRegistry.containsKey(name)) {
            return this.collectionRegistry.get(name);
        }
        if (!this.nitrite.hasCollection(name)) {
            throw new TransactionException("Collection " + name + " does not exists");
        }
        NitriteCollection primary = this.nitrite.getCollection(name);
        NitriteMap<NitriteId, Document> txMap = this.transactionStore.openMap(name, NitriteId.class, Document.class);
        TransactionContext context = new TransactionContext();
        context.setCollectionName(name);
        context.setNitriteMap(txMap);
        context.setJournal(new LinkedList<JournalEntry>());
        context.setConfig(this.transactionConfig);
        DefaultTransactionalCollection txCollection = new DefaultTransactionalCollection(primary, context);
        this.collectionRegistry.put(name, txCollection);
        this.contextMap.put(name, context);
        return txCollection;
    }

    @Override
    public synchronized <T> ObjectRepository<T> getRepository(Class<T> type) {
        this.checkState();
        String name = ObjectUtils.findRepositoryName(type, null);
        if (this.repositoryRegistry.containsKey(name)) {
            return this.repositoryRegistry.get(name);
        }
        if (!this.nitrite.hasRepository(type)) {
            throw new TransactionException("Repository of type " + type.getName() + " does not exists");
        }
        ObjectRepository<T> primary = this.nitrite.getRepository(type);
        NitriteMap<NitriteId, Document> txMap = this.transactionStore.openMap(name, NitriteId.class, Document.class);
        TransactionContext context = new TransactionContext();
        context.setCollectionName(name);
        context.setNitriteMap(txMap);
        context.setJournal(new LinkedList<JournalEntry>());
        context.setConfig(this.transactionConfig);
        NitriteCollection primaryCollection = primary.getDocumentCollection();
        DefaultTransactionalCollection backingCollection = new DefaultTransactionalCollection(primaryCollection, context);
        DefaultTransactionalRepository<T> txRepository = new DefaultTransactionalRepository<T>(type, primary, (NitriteCollection)backingCollection, (NitriteConfig)this.transactionConfig);
        this.repositoryRegistry.put(name, txRepository);
        this.contextMap.put(name, context);
        return txRepository;
    }

    @Override
    public synchronized <T> ObjectRepository<T> getRepository(Class<T> type, String key) {
        this.checkState();
        String name = ObjectUtils.findRepositoryName(type, key);
        if (this.repositoryRegistry.containsKey(name)) {
            return this.repositoryRegistry.get(name);
        }
        if (!this.nitrite.hasRepository(type, key)) {
            throw new TransactionException("Repository of type " + type.getName() + " and key " + key + " does not exists");
        }
        ObjectRepository<T> primary = this.nitrite.getRepository(type, key);
        NitriteMap<NitriteId, Document> txMap = this.transactionStore.openMap(name, NitriteId.class, Document.class);
        TransactionContext context = new TransactionContext();
        context.setCollectionName(name);
        context.setNitriteMap(txMap);
        context.setJournal(new LinkedList<JournalEntry>());
        context.setConfig(this.transactionConfig);
        NitriteCollection primaryCollection = primary.getDocumentCollection();
        DefaultTransactionalCollection backingCollection = new DefaultTransactionalCollection(primaryCollection, context);
        DefaultTransactionalRepository<T> txRepository = new DefaultTransactionalRepository<T>(type, primary, (NitriteCollection)backingCollection, (NitriteConfig)this.transactionConfig);
        this.repositoryRegistry.put(name, txRepository);
        this.contextMap.put(name, context);
        return txRepository;
    }

    @Override
    public synchronized <T> ObjectRepository<T> getRepository(EntityDecorator<T> entityDecorator) {
        this.checkState();
        String name = ObjectUtils.findRepositoryNameByDecorator(entityDecorator, null);
        if (this.repositoryRegistry.containsKey(name)) {
            return this.repositoryRegistry.get(name);
        }
        if (!this.nitrite.hasRepository(entityDecorator)) {
            throw new TransactionException("Repository of type " + entityDecorator.getEntityName() + " does not exists");
        }
        ObjectRepository<T> primary = this.nitrite.getRepository(entityDecorator);
        NitriteMap<NitriteId, Document> txMap = this.transactionStore.openMap(name, NitriteId.class, Document.class);
        TransactionContext context = new TransactionContext();
        context.setCollectionName(name);
        context.setNitriteMap(txMap);
        context.setJournal(new LinkedList<JournalEntry>());
        context.setConfig(this.transactionConfig);
        NitriteCollection primaryCollection = primary.getDocumentCollection();
        DefaultTransactionalCollection backingCollection = new DefaultTransactionalCollection(primaryCollection, context);
        DefaultTransactionalRepository<T> txRepository = new DefaultTransactionalRepository<T>(entityDecorator, primary, (NitriteCollection)backingCollection, this.transactionConfig);
        this.repositoryRegistry.put(name, txRepository);
        this.contextMap.put(name, context);
        return txRepository;
    }

    @Override
    public synchronized <T> ObjectRepository<T> getRepository(EntityDecorator<T> entityDecorator, String key) {
        this.checkState();
        String name = ObjectUtils.findRepositoryNameByDecorator(entityDecorator, key);
        if (this.repositoryRegistry.containsKey(name)) {
            return this.repositoryRegistry.get(name);
        }
        if (!this.nitrite.hasRepository(entityDecorator, key)) {
            throw new TransactionException("Repository of type " + entityDecorator.getEntityName() + " and key " + key + " does not exists");
        }
        ObjectRepository<T> primary = this.nitrite.getRepository(entityDecorator, key);
        NitriteMap<NitriteId, Document> txMap = this.transactionStore.openMap(name, NitriteId.class, Document.class);
        TransactionContext context = new TransactionContext();
        context.setCollectionName(name);
        context.setNitriteMap(txMap);
        context.setJournal(new LinkedList<JournalEntry>());
        context.setConfig(this.transactionConfig);
        NitriteCollection primaryCollection = primary.getDocumentCollection();
        DefaultTransactionalCollection backingCollection = new DefaultTransactionalCollection(primaryCollection, context);
        DefaultTransactionalRepository<T> txRepository = new DefaultTransactionalRepository<T>(entityDecorator, primary, (NitriteCollection)backingCollection, this.transactionConfig);
        this.repositoryRegistry.put(name, txRepository);
        this.contextMap.put(name, context);
        return txRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() {
        this.checkState();
        this.state = TransactionState.PartiallyCommitted;
        for (Map.Entry<String, TransactionContext> contextEntry : this.contextMap.entrySet()) {
            String collectionName = contextEntry.getKey();
            TransactionContext transactionContext = contextEntry.getValue();
            Stack<UndoEntry> undoLog = this.undoRegistry.containsKey(collectionName) ? this.undoRegistry.get(collectionName) : new Stack<UndoEntry>();
            Lock lock = this.lockService.getWriteLock(collectionName);
            try {
                lock.lock();
                Queue<JournalEntry> commitLog = transactionContext.getJournal();
                int length = commitLog.size();
                for (int i = 0; i < length; ++i) {
                    Command commitCommand;
                    JournalEntry entry = commitLog.poll();
                    if (entry == null || (commitCommand = entry.getCommit()) == null) continue;
                    try {
                        commitCommand.execute();
                        continue;
                    }
                    finally {
                        UndoEntry undoEntry = new UndoEntry();
                        undoEntry.setCollectionName(collectionName);
                        undoEntry.setRollback(entry.getRollback());
                        undoLog.push(undoEntry);
                    }
                }
            }
            catch (TransactionException te) {
                this.state = TransactionState.Failed;
                log.error("Error while committing transaction", (Throwable)te);
                throw te;
            }
            catch (Exception e) {
                this.state = TransactionState.Failed;
                log.error("Error while committing transaction", (Throwable)e);
                throw new TransactionException("Error committing transaction", e);
            }
            finally {
                this.undoRegistry.put(collectionName, undoLog);
                transactionContext.getActive().set(false);
                lock.unlock();
            }
        }
        this.state = TransactionState.Committed;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() {
        this.state = TransactionState.Aborted;
        for (Map.Entry<String, Stack<UndoEntry>> entry : this.undoRegistry.entrySet()) {
            String collectionName = entry.getKey();
            Stack<UndoEntry> undoLog = entry.getValue();
            Lock writeLock = this.lockService.getWriteLock(collectionName);
            try {
                writeLock.lock();
                int size = undoLog.size();
                for (int i = 0; i < size; ++i) {
                    UndoEntry undoEntry = undoLog.pop();
                    if (undoEntry == null) continue;
                    Command rollbackCommand = undoEntry.getRollback();
                    rollbackCommand.execute();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        this.close();
    }

    @Override
    public synchronized void close() {
        try {
            this.state = TransactionState.Closed;
            for (TransactionContext context : this.contextMap.values()) {
                context.getActive().set(false);
            }
            this.contextMap.clear();
            this.collectionRegistry.clear();
            this.repositoryRegistry.clear();
            this.undoRegistry.clear();
            this.transactionStore.close();
            this.transactionConfig.close();
        }
        catch (Exception e) {
            throw new TransactionException("Error closing transaction", e);
        }
    }

    @Override
    public synchronized TransactionState getState() {
        return this.state;
    }

    private void prepare() {
        this.contextMap = new ConcurrentHashMap<String, TransactionContext>();
        this.collectionRegistry = new ConcurrentHashMap<String, NitriteCollection>();
        this.repositoryRegistry = new ConcurrentHashMap();
        this.undoRegistry = new ConcurrentHashMap<String, Stack<UndoEntry>>();
        this.id = UUID.randomUUID().toString();
        NitriteStore<?> nitriteStore = this.nitrite.getStore();
        NitriteConfig nitriteConfig = this.nitrite.getConfig();
        this.transactionConfig = new TransactionConfig(nitriteConfig);
        this.transactionConfig.loadModule(NitriteModule.module(new TransactionStore(nitriteStore)));
        this.transactionConfig.autoConfigure();
        this.transactionConfig.initialize();
        this.transactionStore = (TransactionStore)this.transactionConfig.getNitriteStore();
        this.state = TransactionState.Active;
    }

    private void checkState() {
        if (this.state != TransactionState.Active) {
            throw new TransactionException("Transaction is not active");
        }
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

