/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.TemplateException;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.log.LogUtil;

public class TemplateEngineFactory {
    public static TemplateEngine getEngine() {
        TemplateEngine engine = (TemplateEngine)Singleton.get((String)TemplateEngine.class.getName(), TemplateEngineFactory::createEngine);
        LogUtil.debug((String)"Use [{}] Template Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static TemplateEngine createEngine() {
        return TemplateEngineFactory.createEngine(TemplateConfig.DEFAULT);
    }

    public static TemplateEngine createEngine(TemplateConfig config) {
        return TemplateEngineFactory.doCreateEngine(config);
    }

    private static TemplateEngine doCreateEngine(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? (TemplateEngine)ConstructorUtil.newInstance(customEngineClass, (Object[])new Object[0]) : (TemplateEngine)SpiUtil.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found! Please add one of template jar to your project !");
    }
}

