/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.io.watch.WatchMonitor;
import org.dromara.hutool.core.io.watch.WatchUtil;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.io.watch.watchers.SimpleWatcher;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.log.LogUtil;
import org.dromara.hutool.setting.AbsSetting;
import org.dromara.hutool.setting.GroupedMap;
import org.dromara.hutool.setting.SettingLoader;
import org.dromara.hutool.setting.props.Props;

public class Setting
extends AbsSetting
implements Map<String, String> {
    private static final long serialVersionUID = 3618305164959883393L;
    public static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    public static final String EXT_NAME = "setting";
    private GroupedMap groupedMap;
    private boolean logIfNull;
    protected Resource resource;
    private SettingLoader loader;
    private WatchMonitor watchMonitor;

    public static Setting of() {
        return new Setting();
    }

    public Setting() {
        this.groupedMap = new GroupedMap();
    }

    public Setting(String path) {
        this(path, false);
    }

    public Setting(String path, boolean isUseVariable) {
        this(path, DEFAULT_CHARSET, isUseVariable);
    }

    public Setting(String path, Charset charset, boolean isUseVariable) {
        this(ResourceUtil.getResource((String)((String)Assert.notBlank((CharSequence)path))), charset, isUseVariable);
    }

    public Setting(File configFile, Charset charset, boolean isUseVariable) {
        this(ResourceUtil.getResource((File)((File)Assert.notNull((Object)configFile))), charset, isUseVariable);
    }

    public Setting(Resource resource, Charset charset, boolean isUseVariable) {
        this(resource, new SettingLoader(charset, isUseVariable));
    }

    public Setting(Resource resource, SettingLoader loader) {
        this.resource = resource;
        if (null == loader) {
            loader = new SettingLoader(DEFAULT_CHARSET, false);
        }
        this.loader = loader;
        this.groupedMap = loader.load(resource);
    }

    public synchronized Setting load() {
        Assert.notNull((Object)this.loader, (String)"SettingLoader must be not null!", (Object[])new Object[0]);
        this.groupedMap = this.loader.load(this.resource);
        return this;
    }

    public void autoLoad() {
        this.autoLoad(null);
    }

    public void autoLoad(final Consumer<Setting> callback) {
        Assert.notNull((Object)this.resource, (String)"Setting resource must be not null !", (Object[])new Object[0]);
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.watchMonitor});
        this.watchMonitor = WatchUtil.ofModify((URL)this.resource.getUrl(), (Watcher)new SimpleWatcher(){
            private static final long serialVersionUID = 5190107321461226190L;

            public void onModify(WatchEvent<?> event, WatchKey key) {
                Setting.this.load();
                if (callback != null) {
                    callback.accept(Setting.this);
                }
            }
        });
        this.watchMonitor.start();
        LogUtil.debug((String)"Auto load for [{}] listenning...", (Object[])new Object[]{this.resource.getUrl()});
    }

    public void stopAutoLoad() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.watchMonitor});
        this.watchMonitor = null;
    }

    public URL getSettingUrl() {
        return null == this.resource ? null : this.resource.getUrl();
    }

    public String getSettingPath() {
        URL settingUrl = this.getSettingUrl();
        return null == settingUrl ? null : settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.groupedMap.size();
    }

    public Object getObjByGroup(CharSequence key, CharSequence group, Object defaultValue) {
        String result = this.groupedMap.get(group, key);
        if (result == null && this.logIfNull) {
            LogUtil.debug((String)"No key [{}] in group [{}] !", (Object[])new Object[]{key, group});
        }
        return result;
    }

    public String getAndRemove(String ... keys) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return value;
    }

    public Map<String, String> getMap(String group) {
        Object map = this.groupedMap.get(group);
        return null != map ? map : new LinkedHashMap(0);
    }

    public Setting getSetting(String group) {
        Setting setting = new Setting();
        setting.putAll((Map<? extends String, ? extends String>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public Props getProps(String group) {
        Props props = new Props();
        props.putAll(this.getMap(group));
        return props;
    }

    public void store() {
        URL resourceUrl = this.getSettingUrl();
        Assert.notNull((Object)resourceUrl, (String)"Setting path must be not null !", (Object[])new Object[0]);
        this.store(FileUtil.file((URL)resourceUrl));
    }

    public void store(String absolutePath) {
        this.store(FileUtil.touch((String)absolutePath));
    }

    public void store(File file) {
        Assert.notNull((Object)this.loader, (String)"SettingLoader must be not null!", (Object[])new Object[0]);
        this.loader.store(this.groupedMap, file);
    }

    public Props toProps() {
        Props props = new Props();
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            String group = groupEntry.getKey();
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (null == key || null == value) continue;
                props.setProperty(StrUtil.isEmpty((CharSequence)group) ? key : group + '.' + key, value);
            }
        }
        return props;
    }

    public GroupedMap getGroupedMap() {
        return this.groupedMap;
    }

    public List<String> getGroups() {
        return ListUtil.of(this.groupedMap.keySet());
    }

    public Setting setVarRegex(String regex) {
        if (null == this.loader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.loader.setVarRegex(regex);
        return this;
    }

    public Setting setLogIfNull(boolean logIfNull) {
        this.logIfNull = logIfNull;
        return this;
    }

    public boolean isEmpty(String group) {
        return this.groupedMap.isEmpty(group);
    }

    public boolean containsKey(String group, String key) {
        return this.groupedMap.containsKey(group, key);
    }

    public boolean containsValue(String group, String value) {
        return this.groupedMap.containsValue(group, value);
    }

    public String putByGroup(String key, String group, String value) {
        return this.groupedMap.put(group, key, value);
    }

    public String remove(String group, Object key) {
        return this.groupedMap.remove(group, ConvertUtil.toStr((Object)key));
    }

    public Setting putAll(String group, Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll(group, m);
        return this;
    }

    public Setting addSetting(Setting setting) {
        for (Map.Entry<String, LinkedHashMap<String, String>> e : setting.getGroupedMap().entrySet()) {
            this.putAll(e.getKey(), (Map<? extends String, ? extends String>)e.getValue());
        }
        return this;
    }

    public Setting clear(String group) {
        this.groupedMap.clear(group);
        return this;
    }

    public Set<String> keySet(String group) {
        return this.groupedMap.keySet(group);
    }

    public Collection<String> values(String group) {
        return this.groupedMap.values(group);
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        return this.groupedMap.entrySet(group);
    }

    public Setting set(String key, String value) {
        this.put(key, value);
        return this;
    }

    public Setting setFields(SerSupplier<String> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaUtil.getFieldName((Serializable)f), (String)f.get()));
        return this;
    }

    public Setting setByGroup(String key, String group, String value) {
        this.putByGroup(key, group, value);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.groupedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.groupedMap.containsKey("", ConvertUtil.toStr((Object)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.groupedMap.containsValue("", ConvertUtil.toStr((Object)value));
    }

    @Override
    public String get(Object key) {
        return this.getStr((String)key);
    }

    @Override
    public String put(String key, String value) {
        return this.groupedMap.put("", key, value);
    }

    @Override
    public String remove(Object key) {
        return this.remove("", key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll("", m);
    }

    @Override
    public void clear() {
        this.groupedMap.clear("");
    }

    @Override
    public Set<String> keySet() {
        return this.groupedMap.keySet("");
    }

    @Override
    public Collection<String> values() {
        return this.groupedMap.values("");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.groupedMap.entrySet("");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupedMap.hashCode();
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (!this.groupedMap.equals(other.groupedMap)) {
            return false;
        }
        if (this.resource == null) {
            return other.resource == null;
        }
        return this.resource.equals(other.resource);
    }

    public String toString() {
        return this.groupedMap.toString();
    }
}

