/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.nodeTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.InitializerDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.VoidType;

public interface NodeWithMembers<N extends Node> {
    public NodeList<BodyDeclaration<?>> getMembers();

    public void tryAddImportToParentCompilationUnit(Class<?> var1);

    default public BodyDeclaration<?> getMember(int i) {
        return (BodyDeclaration)this.getMembers().get(i);
    }

    default public N setMember(int i, BodyDeclaration<?> member) {
        this.getMembers().set(i, member);
        return (N)((Node)((Object)this));
    }

    default public N addMember(BodyDeclaration<?> member) {
        this.getMembers().add(member);
        return (N)((Node)((Object)this));
    }

    public N setMembers(NodeList<BodyDeclaration<?>> var1);

    default public FieldDeclaration addField(Class<?> typeClass, String name, Modifier ... modifiers) {
        this.tryAddImportToParentCompilationUnit(typeClass);
        return this.addField(typeClass.getSimpleName(), name, modifiers);
    }

    default public FieldDeclaration addField(String type, String name, Modifier ... modifiers) {
        return this.addField(JavaParser.parseType(type), name, modifiers);
    }

    default public FieldDeclaration addField(Type type, String name, Modifier ... modifiers) {
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        VariableDeclarator variable = new VariableDeclarator(type, name);
        fieldDeclaration.getVariables().add(variable);
        fieldDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        this.getMembers().add(fieldDeclaration);
        return fieldDeclaration;
    }

    default public FieldDeclaration addFieldWithInitializer(Type type, String name, Expression initializer, Modifier ... modifiers) {
        FieldDeclaration declaration = this.addField(type, name, modifiers);
        declaration.getVariables().iterator().next().setInitializer(initializer);
        return declaration;
    }

    default public FieldDeclaration addPrivateField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PRIVATE);
    }

    default public FieldDeclaration addPrivateField(String type, String name) {
        return this.addField(type, name, Modifier.PRIVATE);
    }

    default public FieldDeclaration addPublicField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PUBLIC);
    }

    default public FieldDeclaration addPublicField(String type, String name) {
        return this.addField(type, name, Modifier.PUBLIC);
    }

    default public FieldDeclaration addProtectedField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PROTECTED);
    }

    default public FieldDeclaration addProtectedField(String type, String name) {
        return this.addField(type, name, Modifier.PROTECTED);
    }

    default public MethodDeclaration addMethod(String methodName, Modifier ... modifiers) {
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        methodDeclaration.setName(methodName);
        methodDeclaration.setType(new VoidType());
        methodDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        this.getMembers().add(methodDeclaration);
        return methodDeclaration;
    }

    default public BlockStmt addInitializer() {
        BlockStmt block = new BlockStmt();
        InitializerDeclaration initializerDeclaration = new InitializerDeclaration(false, block);
        this.getMembers().add(initializerDeclaration);
        return block;
    }

    default public BlockStmt addStaticInitializer() {
        BlockStmt block = new BlockStmt();
        InitializerDeclaration initializerDeclaration = new InitializerDeclaration(true, block);
        this.getMembers().add(initializerDeclaration);
        return block;
    }

    default public List<MethodDeclaration> getMethodsByName(String name) {
        return Collections.unmodifiableList(this.getMethods().stream().filter(m -> m.getNameAsString().equals(name)).collect(Collectors.toList()));
    }

    default public List<MethodDeclaration> getMethods() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof MethodDeclaration).map(m -> (MethodDeclaration)m).collect(Collectors.toList()));
    }

    default public List<MethodDeclaration> getMethodsByParameterTypes(String ... paramTypes) {
        return Collections.unmodifiableList(this.getMethods().stream().filter(m -> m.hasParametersOfType(paramTypes)).collect(Collectors.toList()));
    }

    default public List<MethodDeclaration> getMethodsBySignature(String name, String ... paramTypes) {
        return Collections.unmodifiableList(this.getMethodsByName(name).stream().filter(m -> m.hasParametersOfType(paramTypes)).collect(Collectors.toList()));
    }

    default public List<MethodDeclaration> getMethodsByParameterTypes(Class<?> ... paramTypes) {
        return Collections.unmodifiableList(this.getMethods().stream().filter(m -> m.hasParametersOfType(paramTypes)).collect(Collectors.toList()));
    }

    default public Optional<FieldDeclaration> getFieldByName(String name) {
        return this.getMembers().stream().filter(m -> m instanceof FieldDeclaration).map(f -> (FieldDeclaration)f).filter(f -> f.getVariables().stream().anyMatch(var -> var.getNameAsString().equals(name))).findFirst();
    }

    default public List<FieldDeclaration> getFields() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof FieldDeclaration).map(m -> (FieldDeclaration)m).collect(Collectors.toList()));
    }
}

