/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.javaparser.ast.drlx.OOPathChunk;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.RuleBody;
import org.drools.javaparser.ast.drlx.RuleConsequence;
import org.drools.javaparser.ast.drlx.RuleDeclaration;
import org.drools.javaparser.ast.drlx.RuleItem;
import org.drools.javaparser.ast.drlx.RulePattern;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.visitor.AbstractVoidRuleVisitor;
import org.drools.javaparser.printer.PrettyPrintVisitor;

public class DrlPrintVisitor
extends AbstractVoidRuleVisitor<Void, PrettyPrintVisitor> {
    public DrlPrintVisitor(PrettyPrintVisitor visitor) {
        super(visitor);
    }

    @Override
    public void visit(RuleDeclaration rule, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(rule.getComment(), arg);
        for (AnnotationExpr ae : rule.getAnnotations()) {
            ae.accept(this.visitor, arg);
            ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        }
        ((PrettyPrintVisitor)this.visitor).printer.print("rule ");
        rule.getName().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.println(" when ");
        rule.getRuleBody().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.println("end");
    }

    @Override
    public void visit(RuleBody ruleBody, Void arg) {
        HashMap<String, RuleConsequence> consequences = new HashMap<String, RuleConsequence>();
        RuleConsequence lastConsequence = null;
        int itemsNr = ruleBody.getItems().size();
        for (int i = 0; i < itemsNr; ++i) {
            RuleItem item = (RuleItem)ruleBody.getItems().get(i);
            if (item instanceof RulePattern) {
                RulePattern pattern = (RulePattern)item;
                pattern.accept(this.visitor, arg);
                ((PrettyPrintVisitor)this.visitor).printer.println();
                continue;
            }
            if (!(item instanceof RuleConsequence)) continue;
            RuleConsequence consequence2 = (RuleConsequence)item;
            if (i == itemsNr - 1) {
                lastConsequence = consequence2;
                continue;
            }
            String consequenceName = "exec" + i;
            consequences.put(consequenceName, consequence2);
            ((PrettyPrintVisitor)this.visitor).printer.println("do[" + consequenceName + "] ");
        }
        ((PrettyPrintVisitor)this.visitor).printer.println("then ");
        if (lastConsequence != null) {
            lastConsequence.accept(this.visitor, arg);
        }
        consequences.forEach((name, consequence) -> {
            ((PrettyPrintVisitor)this.visitor).printer.println("then[" + name + "] ");
            consequence.accept(this.visitor, arg);
        });
    }

    @Override
    public void visit(RulePattern rulePattern, Void arg) {
        rulePattern.getBind().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.print(" : ");
        rulePattern.getExpr().accept(this.visitor, arg);
    }

    @Override
    public void visit(RuleConsequence ruleConsequence, Void arg) {
        BlockStmt consequence = ruleConsequence.getBlock();
        if (consequence != null) {
            for (Statement statement : consequence.getStatements()) {
                statement.accept(this.visitor, arg);
                ((PrettyPrintVisitor)this.visitor).printer.println();
            }
        }
    }

    @Override
    public void visit(OOPathExpr expr, Void arg) {
        for (OOPathChunk chunk : expr.getChunks()) {
            chunk.accept(this.visitor, arg);
        }
    }

    @Override
    public void visit(OOPathChunk chunk, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printer.print("/");
        chunk.getField().accept(this.visitor, arg);
        SimpleName inlineCast = chunk.getInlineCast();
        if (inlineCast != null) {
            ((PrettyPrintVisitor)this.visitor).printer.print("#");
            inlineCast.accept(this.visitor, arg);
        }
        List<Expression> condition = chunk.getConditions();
        Iterator<Expression> iterator = condition.iterator();
        if (!condition.isEmpty()) {
            ((PrettyPrintVisitor)this.visitor).printer.print("[");
            Expression first = iterator.next();
            first.accept(this.visitor, arg);
            while (iterator.hasNext()) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                iterator.next().accept(this.visitor, arg);
            }
            ((PrettyPrintVisitor)this.visitor).printer.print("]");
        }
    }
}

