/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.printer.PrettyPrinter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ancompiler.ANCConfiguration;
import org.drools.ancompiler.AssertHandler;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.ancompiler.CompiledNetworkSources;
import org.drools.ancompiler.DebugHandler;
import org.drools.ancompiler.DeclarationsHandler;
import org.drools.ancompiler.DelegateMethodsHandler;
import org.drools.ancompiler.HashedAlphasDeclaration;
import org.drools.ancompiler.InlineFieldReferenceInitHandler;
import org.drools.ancompiler.ModifyHandler;
import org.drools.ancompiler.NodeCollectorHandler;
import org.drools.ancompiler.ObjectTypeNodeParser;
import org.drools.ancompiler.SetNodeReferenceHandler;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.util.index.AlphaRangeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeNodeCompiler {
    private static final String NEWLINE = "\n";
    public static final String PACKAGE_NAME = "org.drools.ancompiler";
    private static final String BINARY_PACKAGE_NAME = "org.drools.ancompiler".replace('.', '/');
    private String className;
    private String generatedClassSimpleName;
    private ObjectTypeNode objectTypeNode;
    private StringBuilder builder = new StringBuilder();
    private static final Logger logger = LoggerFactory.getLogger(ObjectTypeNodeCompiler.class);
    private boolean shouldInline;
    private List<FieldDeclaration> additionalFields = new ArrayList<FieldDeclaration>();
    private ANCConfiguration ancConfiguration;

    public ObjectTypeNodeCompiler(ObjectTypeNode objectTypeNode) {
        this(new ANCConfiguration(), objectTypeNode, false);
    }

    public ObjectTypeNodeCompiler(ANCConfiguration ancConfiguration, ObjectTypeNode objectTypeNode, boolean shouldInline) {
        this.ancConfiguration = ancConfiguration;
        this.shouldInline = shouldInline;
        this.objectTypeNode = objectTypeNode;
        ClassObjectType classObjectType = (ClassObjectType)objectTypeNode.getObjectType();
        this.className = classObjectType.getClassName().replace("$", ".");
        String classObjectTypeName = classObjectType.getClassName().replace('.', '_');
        String otnHash = String.valueOf(objectTypeNode.hashCode()).replace("-", "");
        this.generatedClassSimpleName = String.format("Compiled%sNetwork%d%s", classObjectTypeName, objectTypeNode.getId(), otnHash);
    }

    public void addAdditionalFields(FieldDeclaration additionalFieldDeclarations) {
        this.additionalFields.add(additionalFieldDeclarations);
    }

    public CompiledNetworkSources generateSource() {
        Collection<CompilationUnit> initClasses;
        this.createClassDeclaration();
        ObjectTypeNodeParser parser = new ObjectTypeNodeParser(this.objectTypeNode);
        logger.debug("Compiling Alpha Network: ");
        DebugHandler debugHandler = new DebugHandler();
        parser.accept(debugHandler);
        if (parser.getIndexableConstraints().size() > 1) {
            logger.warn("Alpha Network Compiler with multiple Indexable Constraints is not supported, reverting to non hashed-ANC. This might be slower ");
            parser.setTraverseHashedAlphaNodes(false);
        }
        this.createAdditionalFields(this.builder);
        DeclarationsHandler declarations = new DeclarationsHandler(this.builder, this.ancConfiguration.getDisableContextEntry());
        parser.accept(declarations);
        Collection<HashedAlphasDeclaration> hashedAlphaDeclarations = declarations.getHashedAlphaDeclarations();
        Map<String, AlphaRangeIndex> rangeIndexDeclarationMap = declarations.getRangeIndexDeclarationMap();
        this.createConstructor(hashedAlphaDeclarations, rangeIndexDeclarationMap);
        NodeCollectorHandler nodeCollectors = new NodeCollectorHandler();
        parser.accept(nodeCollectors);
        this.builder.append(String.format("protected boolean isInlined() { return %s; }", this.shouldInline));
        if (this.shouldInline) {
            this.addEmptySetNetworkReference(this.builder);
            InlineFieldReferenceInitHandler inlineFieldReferenceInitHandler = new InlineFieldReferenceInitHandler(nodeCollectors.getNodes(), this.additionalFields);
            inlineFieldReferenceInitHandler.emitCode(this.builder);
            initClasses = inlineFieldReferenceInitHandler.getPartitionedNodeInitialisationClasses();
        } else {
            SetNodeReferenceHandler partitionedSwitch = new SetNodeReferenceHandler(nodeCollectors.getNodes());
            partitionedSwitch.emitCode(this.builder);
            initClasses = null;
        }
        AssertHandler assertHandler = new AssertHandler(this.className, !hashedAlphaDeclarations.isEmpty());
        parser.accept(assertHandler);
        this.builder.append(assertHandler.emitCode());
        ModifyHandler modifyHandler = new ModifyHandler(this.className, !hashedAlphaDeclarations.isEmpty());
        if (this.ancConfiguration.isEnableModifyObject()) {
            parser.accept(modifyHandler);
        }
        this.builder.append(modifyHandler.emitCode());
        DelegateMethodsHandler delegateMethodsHandler = new DelegateMethodsHandler(this.builder);
        parser.accept(delegateMethodsHandler);
        this.builder.append("}").append(NEWLINE);
        String sourceCode = this.builder.toString();
        if (this.ancConfiguration.isPrettyPrint()) {
            sourceCode = new PrettyPrinter().print((Node)StaticJavaParser.parse((String)sourceCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Generated Compiled Alpha Network %s", sourceCode));
        }
        return new CompiledNetworkSources(sourceCode, parser.getIndexableConstraint(), this.getName(), this.getSourceName(), this.objectTypeNode, rangeIndexDeclarationMap, initClasses);
    }

    private void addEmptySetNetworkReference(StringBuilder builder) {
        builder.append("   @Override\n    protected void setNetworkNodeReference(org.drools.core.common.NetworkNode networkNode) {\n        \n    }");
    }

    private void createAdditionalFields(StringBuilder builder) {
        for (FieldDeclaration fd : this.additionalFields) {
            builder.append(fd.toString());
        }
        MethodDeclaration initMethod = new MethodDeclaration();
        initMethod.setModifiers(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier()}));
        initMethod.setType((Type)new VoidType());
        initMethod.setName("init");
        Parameter args = new Parameter(StaticJavaParser.parseType((String)"Object"), "args");
        args.setVarArgs(true);
        initMethod.setParameters(NodeList.nodeList((Node[])new Parameter[]{args}));
        BlockStmt initMethodStatements = new BlockStmt();
        int additionalFieldsSize = this.additionalFields.size();
        for (int i = 0; i < additionalFieldsSize; ++i) {
            FieldDeclaration fd = this.additionalFields.get(i);
            VariableDeclarator fieldType = (VariableDeclarator)fd.getVariables().iterator().next();
            String fieldInitFromVarargs = String.format("%s = (%s)%s;", fieldType.getName(), fieldType.getType(), String.format("args[%d]", i));
            Statement initStatement = StaticJavaParser.parseStatement((String)fieldInitFromVarargs);
            initMethodStatements.addStatement(initStatement);
        }
        initMethod.setBody(initMethodStatements);
        builder.append(initMethod);
    }

    private void createClassDeclaration() {
        this.builder.append("package ").append(PACKAGE_NAME).append(";").append(NEWLINE);
        this.builder.append("public class ").append(this.generatedClassSimpleName).append(" extends ").append(CompiledNetwork.class.getName()).append("{ ").append(NEWLINE);
        this.builder.append(String.format("private static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(%s.class);%n", this.generatedClassSimpleName));
        this.builder.append(ReadAccessor.class.getCanonicalName() + " readAccessor;\n");
    }

    private void createConstructor(Collection<HashedAlphasDeclaration> hashedAlphaDeclarations, Map<String, AlphaRangeIndex> rangeIndexDeclarationMap) {
        this.builder.append("public ").append(this.generatedClassSimpleName).append("(" + ReadAccessor.class.getCanonicalName() + " readAccessor, java.util.Map<String, " + AlphaRangeIndex.class.getCanonicalName() + "> rangeIndexDeclarationMap) {").append(NEWLINE);
        this.builder.append("this.readAccessor = readAccessor;\n");
        for (HashedAlphasDeclaration declaration : hashedAlphaDeclarations) {
            String mapVariableName = declaration.getVariableName();
            for (Object hashedValue : declaration.getHashedValues()) {
                String nodeId;
                Object value = hashedValue;
                if (value == null) {
                    nodeId = declaration.getNodeId(hashedValue);
                    this.builder.append(mapVariableName).append(".put(null,").append(nodeId).append(");");
                    this.builder.append(NEWLINE);
                    continue;
                }
                if (value.getClass().equals(String.class)) {
                    value = "\"" + value + "\"";
                } else if (value instanceof Long) {
                    value = value + "L";
                } else if (value instanceof BigDecimal) {
                    value = "new java.math.BigDecimal(\"" + value + "\")";
                } else if (value instanceof BigInteger) {
                    value = "new java.math.BigInteger(\"" + value + "\")";
                }
                nodeId = declaration.getNodeId(hashedValue);
                this.builder.append(mapVariableName).append(".put(").append(value).append(", ").append(nodeId).append(");");
                this.builder.append(NEWLINE);
            }
        }
        for (String variableName : rangeIndexDeclarationMap.keySet()) {
            this.builder.append("this." + variableName + " = rangeIndexDeclarationMap.get(\"" + variableName + "\");");
            this.builder.append(NEWLINE);
        }
        this.builder.append("}").append(NEWLINE);
    }

    private String getName() {
        return this.getPackageName() + "." + this.generatedClassSimpleName;
    }

    private String getBinaryName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".class";
    }

    private String getSourceName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".java";
    }

    private String getPackageName() {
        return PACKAGE_NAME;
    }

    public static List<CompiledNetworkSources> compiledNetworkSources(Rete rete) {
        return ObjectTypeNodeCompiler.objectTypeNodeCompiler(rete).stream().map(ObjectTypeNodeCompiler::generateSource).collect(Collectors.toList());
    }

    public static List<ObjectTypeNodeCompiler> objectTypeNodeCompiler(Rete rete) {
        return ObjectTypeNodeCompiler.objectTypeNodes(rete).stream().map(ObjectTypeNodeCompiler::new).collect(Collectors.toList());
    }

    public static List<ObjectTypeNode> objectTypeNodes(Rete rete) {
        return rete.getEntryPointNodes().values().stream().flatMap(ep -> ep.getObjectTypeNodes().values().stream()).filter(ObjectTypeNodeCompiler::shouldCreateCompiledAlphaNetwork).collect(Collectors.toList());
    }

    private static boolean shouldCreateCompiledAlphaNetwork(ObjectTypeNode f) {
        return !f.getObjectType().isAssignableTo(InitialFact.class) && !(f.getObjectSinkPropagator() instanceof CompiledNetwork);
    }

    public static Map<String, CompiledNetworkSources> compiledNetworkSourceMap(Rete rete) {
        List<CompiledNetworkSources> compiledNetworkSources = ObjectTypeNodeCompiler.compiledNetworkSources(rete);
        return compiledNetworkSources.stream().collect(Collectors.toMap(CompiledNetworkSources::getName, Function.identity()));
    }

    public static Map<ObjectTypeNode, String> otnWithClassName(Rete rete) {
        List<ObjectTypeNodeCompiler> compiledNetworkSources = ObjectTypeNodeCompiler.objectTypeNodeCompiler(rete);
        return compiledNetworkSources.stream().collect(Collectors.toMap(k -> k.objectTypeNode, ObjectTypeNodeCompiler::getName));
    }
}

