/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

public interface LambdaPrinter {
    public String getLambdaFingerprint(Object var1);

    public static String print(Object lambda) {
        return Factory.get().getLambdaFingerprint(lambda);
    }

    public static class DummyLambdaPrinter
    implements LambdaPrinter {
        @Override
        public String getLambdaFingerprint(Object lambda) {
            return lambda.toString();
        }
    }

    public static class Factory {
        public static LambdaPrinter get() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static LambdaPrinter INSTANCE = LazyHolder.buildPrinter();

            private LazyHolder() {
            }

            private static LambdaPrinter buildPrinter() {
                try {
                    return (LambdaPrinter)Class.forName("org.drools.modelcompiler.util.LambdaIntrospector").newInstance();
                }
                catch (Exception e) {
                    System.err.println("Unable to find LambdaIntrospector, caused by: " + e.getMessage());
                    return new DummyLambdaPrinter();
                }
            }
        }
    }
}

