/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class AfterPredicate
extends AbstractTemporalPredicate<AfterPredicate> {
    private final long initRange;
    private final long finalRange;

    public AfterPredicate() {
        this(1L, Long.MAX_VALUE);
    }

    public AfterPredicate(long dev, TimeUnit devUnit) {
        this(TimeUtil.unitToLong(dev, devUnit), Long.MAX_VALUE);
    }

    public AfterPredicate(long startDev, TimeUnit startDevUnit, long endDev, TimeUnit endDevUnit) {
        this(TimeUtil.unitToLong(startDev, startDevUnit), TimeUtil.unitToLong(endDev, endDevUnit));
    }

    private AfterPredicate(long initRange, long finalRange) {
        this.initRange = initRange;
        this.finalRange = finalRange;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "after[" + this.initRange + ", " + this.finalRange + "]";
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long diff = start1 - end2;
        return this.negated ^ (diff >= this.initRange && diff <= this.finalRange);
    }

    @Override
    public Interval getInterval() {
        long init = this.initRange;
        long end = this.finalRange;
        if (this.negated) {
            if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                init = this.finalRange + 1L;
                end = Long.MAX_VALUE;
            } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                init = Long.MIN_VALUE;
                end = this.initRange - 1L;
            } else if (init == Long.MIN_VALUE) {
                init = 0L;
                end = -1L;
            } else {
                init = Long.MIN_VALUE;
                end = Long.MAX_VALUE;
            }
        }
        return new Interval(init, end);
    }

    @Override
    protected boolean isTemporalPredicateEqualTo(AfterPredicate other) {
        return this.initRange == other.initRange && this.finalRange == other.finalRange;
    }
}

