/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalElementDescr;
import org.drools.compiler.lang.descr.DescrVisitor;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;

public class ForallDescr
extends BaseDescr
implements ConditionalElementDescr {
    private static final long serialVersionUID = 510L;
    public static final String BASE_IDENTIFIER = "$__forallBaseIdentifier";
    private List<BaseDescr> patterns = new ArrayList<BaseDescr>(2);

    @Override
    public void addDescr(BaseDescr baseDescr) {
        this.patterns.add(baseDescr);
    }

    @Override
    public void insertBeforeLast(Class<?> clazz, BaseDescr baseDescr) {
        throw new UnsupportedOperationException("Can't add descriptors to " + this.getClass().getName());
    }

    public List<BaseDescr> getDescrs() {
        return this.patterns;
    }

    public PatternDescr getBasePattern() {
        if (this.patterns.size() > 1) {
            return (PatternDescr)this.patterns.get(0);
        }
        if (this.patterns.size() == 1) {
            PatternDescr original = (PatternDescr)this.patterns.get(0);
            PatternDescr base = original.clone();
            base.getDescrs().clear();
            base.setIdentifier(BASE_IDENTIFIER);
            base.setResource(original.getResource());
            return base;
        }
        return null;
    }

    public boolean isSinglePattern() {
        return this.patterns.size() == 1;
    }

    public BaseDescr getSelfJoinConstraint() {
        if (this.patterns.size() != 2) {
            return null;
        }
        PatternDescr p1 = (PatternDescr)this.patterns.get(0);
        String identifier = p1.getIdentifier();
        if (identifier == null) {
            return null;
        }
        PatternDescr p2 = (PatternDescr)this.patterns.get(1);
        if (!p1.getObjectType().equals(p2.getObjectType())) {
            return null;
        }
        identifier = identifier.replace("$", "\\$");
        for (BaseDescr baseDescr : p2.getConstraint().getDescrs()) {
            if (!(baseDescr instanceof ExprConstraintDescr) || baseDescr.getText() == null || !baseDescr.getText().matches("\\s*this\\s*==\\s*" + identifier + "\\s*")) continue;
            return baseDescr;
        }
        return null;
    }

    public List<BaseDescr> getRemainingPatterns() {
        if (this.patterns.size() > 1) {
            return this.patterns.subList(1, this.patterns.size());
        }
        if (this.patterns.size() == 1) {
            PatternDescr original = (PatternDescr)this.patterns.get(0);
            PatternDescr remaining = original.clone();
            remaining.addConstraint(new ExprConstraintDescr("this == $__forallBaseIdentifier"));
            remaining.setResource(original.getResource());
            return Collections.singletonList(remaining);
        }
        return Collections.emptyList();
    }

    @Override
    public void addOrMerge(BaseDescr baseDescr) {
        this.patterns.add(baseDescr);
    }

    @Override
    public boolean removeDescr(BaseDescr baseDescr) {
        return baseDescr == null ? false : this.patterns.remove(baseDescr);
    }

    public String toString() {
        return "forall( " + this.patterns + " )";
    }

    @Override
    public void accept(DescrVisitor visitor) {
        visitor.visit(this);
    }
}

