/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.kiesession.agenda;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.ObjectTypeNode;

public class PartitionedDefaultAgenda extends DefaultAgenda {

    private final int partition;

    PartitionedDefaultAgenda(InternalWorkingMemory workingMemory,
                             ExecutionStateMachine executionStateMachine,
                             int partition) {
        super(workingMemory, executionStateMachine);
        this.partition = partition;
    }

    /**
     * Do not use this constructor! It should be used just by deserialization.
     */
    @Override
    protected void retractFactHandle(PropagationContext ectx, InternalFactHandle factHandle) {
        ObjectTypeNode.retractLeftTuples(factHandle, ectx, workingMemory, partition );
        ObjectTypeNode.retractRightTuples(factHandle, ectx, workingMemory, partition );
    }

    @Override
    protected boolean isPendingRemoveFactHandleFromStore(InternalFactHandle factHandle) {
        return isMainPartition() && super.isPendingRemoveFactHandleFromStore(factHandle);
    }

    private boolean isMainPartition() {
        return partition == 0;
    }
}
