/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.time.Interval;
import org.drools.core.util.TimeIntervalParser;
import org.drools.model.SingleConstraint;
import org.drools.model.constraints.FixedTemporalConstraint;
import org.drools.model.constraints.TemporalConstraint;
import org.drools.model.functions.Function1;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;

public class TemporalConstraintEvaluator
extends ConstraintEvaluator {
    private final Interval interval;
    private Declaration patternDeclaration;

    public TemporalConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        super(declarations, pattern, constraint);
        TemporalPredicate temporalPredicate = ((TemporalConstraint)constraint).getTemporalPredicate();
        this.interval = new Interval(temporalPredicate.getInterval().getLowerBound(), temporalPredicate.getInterval().getUpperBound());
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
        TemporalConstraint temporalConstraint = (TemporalConstraint)this.constraint;
        InternalFactHandle[] fhs = this.getBetaInvocationFactHandles(handle, tuple);
        long start1 = this.getStartTimestamp(fhs[0], reteEvaluator, this.getDeclarations()[0], temporalConstraint.getF1());
        long duration1 = this.getDuration(fhs[0]);
        long end1 = start1 + duration1;
        long start2 = this.getStartTimestamp(fhs[1], reteEvaluator, this.getDeclarations()[1], temporalConstraint.getF2());
        long duration2 = this.getDuration(fhs[1]);
        long end2 = start2 + duration2;
        TemporalPredicate temporalPredicate = temporalConstraint.getTemporalPredicate();
        if (temporalPredicate.isThisOnRight()) {
            return temporalPredicate.evaluate(start2, duration2, end2, start1, duration1, end1);
        }
        return temporalPredicate.evaluate(start1, duration1, end1, start2, duration2, end2);
    }

    private InternalFactHandle[] getBetaInvocationFactHandles(InternalFactHandle handle, Tuple tuple) {
        InternalFactHandle[] fhs = new InternalFactHandle[this.declarations.length];
        for (int i = 0; i < fhs.length; ++i) {
            fhs[i] = this.declarations[i] == this.patternDeclaration ? handle : tuple.get(this.declarations[i].getTupleIndex());
        }
        return fhs;
    }

    private long getDuration(InternalFactHandle fh) {
        return fh instanceof EventFactHandle ? ((EventFactHandle)fh).getDuration() : 0L;
    }

    private long getStartTimestamp(InternalFactHandle fh, ReteEvaluator reteEvaluator, Declaration decl, Function1<Object, ?> f) {
        if (f != null) {
            return TimeIntervalParser.getTimestampFromDate((Object)f.apply(decl.getValue(reteEvaluator, fh.getObject())));
        }
        return fh instanceof EventFactHandle && !(decl.getExtractor() instanceof LambdaReadAccessor) ? ((EventFactHandle)fh).getStartTimestamp() : TimeIntervalParser.getTimestampFromDate((Object)decl.getValue(reteEvaluator, fh.getObject()));
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        TemporalConstraint temporalConstraint = (TemporalConstraint)this.constraint;
        long start1 = this.getStartTimestamp(handle, reteEvaluator, this.getDeclarations()[0], temporalConstraint.getF1());
        long duration1 = this.getDuration(handle);
        long end1 = start1 + duration1;
        long start2 = this.getNonEventTimestamp(temporalConstraint, handle, reteEvaluator);
        long duration2 = 0L;
        long end2 = start2 + duration2;
        TemporalPredicate temporalPredicate = temporalConstraint.getTemporalPredicate();
        if (temporalPredicate.isThisOnRight()) {
            return temporalPredicate.evaluate(start2, duration2, end2, start1, duration1, end1);
        }
        return temporalPredicate.evaluate(start1, duration1, end1, start2, duration2, end2);
    }

    private long getNonEventTimestamp(TemporalConstraint temporalConstraint, InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        return this.constraint instanceof FixedTemporalConstraint ? ((FixedTemporalConstraint)this.constraint).getValue() : this.getStartTimestamp(handle, reteEvaluator, this.getDeclarations()[1], temporalConstraint.getF2());
    }

    @Override
    public TemporalConstraintEvaluator clone() {
        return new TemporalConstraintEvaluator(this.getDeclarations(), this.getPattern(), this.constraint);
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    protected void setPatternDeclaration(Declaration patternDeclaration) {
        this.patternDeclaration = patternDeclaration;
    }
}

