/*
 * Copyright 2005 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.modelcompiler.constraints;

import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.model.Binding;
import org.drools.model.view.BindViewItem1;
import org.kie.api.runtime.rule.FactHandle;

public class BindingInnerObjectEvaluator extends BindingEvaluator {

    public BindingInnerObjectEvaluator( Binding binding ) {
        super( null, binding );
    }

    @Override
    public Object evaluate(FactHandle handle, BaseTuple tuple, ValueResolver reteEvaluator, Declaration[] declarations, Declaration[] innerDeclarations) {
        return (( BindViewItem1 ) binding).eval( handle.getObject() );
    }
}
