/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.drools.base.base.CoreComponentsBuilder;
import org.drools.base.util.Drools;
import org.drools.model.functions.Function1;
import org.drools.util.ClassUtils;

public class LambdaFieldReader
implements Function1 {
    private final Method accessor;
    private final String field;

    public LambdaFieldReader(Class<?> clazz, String field) {
        this.accessor = ClassUtils.getAccessor(clazz, (String)field);
        this.field = field;
    }

    public Object apply(Object o) {
        try {
            if (this.accessor != null) {
                return this.accessor.invoke(o, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (!Drools.hasMvel()) {
            throw new RuntimeException("Complex timestamp expressions can be used only with drools-mvel on classpath");
        }
        return CoreComponentsBuilder.get().getMVELExecutor().eval(this.field, o);
    }
}

