/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.base.time.TimeUtils;
import org.drools.core.time.TimerExpression;
import org.drools.core.time.impl.CronExpression;
import org.drools.util.ClassUtils;
import org.drools.util.DateUtils;

public class TimerUtil {
    public static boolean validateTimer(String timerString) {
        int colonPos = timerString.indexOf(":");
        int semicolonPos = timerString.indexOf(";");
        String protocol = colonPos < 0 ? "int" : timerString.substring(0, colonPos);
        String body = timerString.substring(colonPos + 1, semicolonPos > 0 ? semicolonPos : timerString.length()).trim();
        switch (protocol) {
            case "int": {
                String[] times = body.trim().split("\\s");
                long delay = 0L;
                long period = 0L;
                if (times.length > 2) {
                    return false;
                }
                try {
                    if (times.length == 1) {
                        delay = TimeUtils.parseTimeString((String)times[0]);
                    } else {
                        delay = TimeUtils.parseTimeString((String)times[0]);
                        period = TimeUtils.parseTimeString((String)times[1]);
                    }
                }
                catch (RuntimeException e) {
                    return false;
                }
                return true;
            }
            case "cron": {
                try {
                    new CronExpression(body);
                }
                catch (ParseException e) {
                    return false;
                }
                return true;
            }
            case "expr": {
                return true;
            }
        }
        return false;
    }

    public static TimerExpression buildTimerExpression(String expression, Map<String, Declaration> decls) {
        if (expression == null) {
            return null;
        }
        try {
            return new ConstantTimerExpression(TimeUtils.parseTimeString((String)expression));
        }
        catch (Exception exception) {
            try {
                return new ConstantTimerExpression(DateUtils.parseDate((String)expression).getTime());
            }
            catch (Exception exception2) {
                String declName;
                Declaration declaration = decls.get(expression);
                if (declaration != null) {
                    return new DeclarationTimerExpression(declaration);
                }
                int dotPos = expression.indexOf(46);
                if (dotPos > 0 && (declaration = decls.get(declName = expression.substring(0, dotPos))) != null) {
                    return new FieldTimerExpression(declaration, expression.substring(dotPos + 1));
                }
                throw new UnsupportedOperationException("Invalid timer expression: " + expression);
            }
        }
    }

    private static class ConstantTimerExpression
    implements TimerExpression {
        private final long value;

        private ConstantTimerExpression(long value) {
            this.value = value;
        }

        public Declaration[] getDeclarations() {
            return new Declaration[0];
        }

        public Object getValue(BaseTuple leftTuple, Declaration[] declrs, ValueResolver valueResolver) {
            return this.value;
        }
    }

    private static class FieldTimerExpression
    implements TimerExpression {
        private final Declaration declaration;
        private final Method method;

        private FieldTimerExpression(Declaration declaration, String field) {
            this.declaration = declaration;
            this.method = ClassUtils.getGetterMethod((Class)declaration.getDeclarationClass(), (String)field);
        }

        public Declaration[] getDeclarations() {
            return new Declaration[]{this.declaration};
        }

        public Object getValue(BaseTuple leftTuple, Declaration[] declrs, ValueResolver valueResolver) {
            try {
                return this.method.invoke(declrs[0].getValue(valueResolver, leftTuple), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DeclarationTimerExpression
    implements TimerExpression {
        private final Declaration declaration;

        private DeclarationTimerExpression(Declaration declaration) {
            this.declaration = declaration;
        }

        public Declaration[] getDeclarations() {
            return new Declaration[]{this.declaration};
        }

        public Object getValue(BaseTuple leftTuple, Declaration[] declrs, ValueResolver valueResolver) {
            return declrs[0].getValue(valueResolver, leftTuple);
        }
    }
}

