/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.factmodel.AccessibleFact;
import org.drools.base.factmodel.AnnotationDefinition;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.factmodel.FieldDefinition;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.util.PropertyReactivityUtil;
import org.drools.base.util.TimeIntervalParser;
import org.drools.model.AnnotationValue;
import org.drools.model.TypeMetaData;
import org.drools.modelcompiler.constraints.LambdaFieldReader;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.drools.util.ClassUtils;
import org.drools.util.TypeResolver;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class TypeDeclarationUtil {
    public static TypeDeclaration createTypeDeclaration(TypeMetaData metaType, PropertySpecificOption propertySpecificOption, TypeResolver typeResolver) {
        Class typeClass = metaType.getType();
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean((Class)typeClass, (PropertySpecificOption)propertySpecificOption);
        typeDeclaration.setTypeClassDef((ClassDefinition)(AccessibleFact.class.isAssignableFrom(typeClass) ? new AccessibleClassDefinition(typeClass, typeResolver) : new DynamicClassDefinition(typeClass)));
        TypeDeclarationUtil.wireClassAnnotations(typeClass, typeDeclaration);
        TypeDeclarationUtil.wireMetaTypeAnnotations(metaType, typeDeclaration);
        TypeDeclarationUtil.wireFields(typeClass, typeDeclaration);
        return typeDeclaration;
    }

    private static void wireMetaTypeAnnotations(TypeMetaData metaType, TypeDeclaration typeDeclaration) {
        block16: for (Map.Entry ann : metaType.getAnnotations().entrySet()) {
            switch ((String)ann.getKey()) {
                case "role": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value") || !annVal.getValue().equals("event")) continue;
                        typeDeclaration.setRole(Role.Type.EVENT);
                    }
                    continue block16;
                }
                case "duration": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value")) continue;
                        TypeDeclarationUtil.wireDurationAccessor(annVal.getValue().toString(), typeDeclaration);
                    }
                    continue block16;
                }
                case "timestamp": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value")) continue;
                        TypeDeclarationUtil.wireTimestampAccessor(annVal.getValue().toString(), typeDeclaration);
                    }
                    continue block16;
                }
                case "expires": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (annVal.getKey().equals("value")) {
                            long offset = TimeIntervalParser.parseSingle((String)annVal.getValue().toString());
                            typeDeclaration.setExpirationOffset(offset == -1L ? Long.MAX_VALUE : offset);
                            typeDeclaration.setExpirationType(Expires.Policy.TIME_HARD);
                            continue;
                        }
                        if (!annVal.getKey().equals("policy")) continue;
                        typeDeclaration.setExpirationType(Enum.valueOf(Expires.Policy.class, annVal.getValue().toString()));
                    }
                    continue block16;
                }
                case "propertyReactive": {
                    typeDeclaration.setPropertyReactive(true);
                    break;
                }
                case "classReactive": {
                    typeDeclaration.setPropertyReactive(false);
                }
            }
        }
    }

    private static void wireClassAnnotations(Class<?> typeClass, TypeDeclaration typeDeclaration) {
        Timestamp timestamp;
        Duration duration = typeClass.getAnnotation(Duration.class);
        if (duration != null) {
            TypeDeclarationUtil.wireDurationAccessor(duration.value(), typeDeclaration);
        }
        if ((timestamp = typeClass.getAnnotation(Timestamp.class)) != null) {
            TypeDeclarationUtil.wireTimestampAccessor(timestamp.value(), typeDeclaration);
        }
    }

    private static void wireFields(Class<?> typeClass, TypeDeclaration typeDeclaration) {
        ClassDefinitionForModel typeClassDef = (ClassDefinitionForModel)typeDeclaration.getTypeClassDef();
        List properties = PropertyReactivityUtil.getAccessibleProperties(typeClass);
        for (String property : properties) {
            typeClassDef.getField(property);
        }
    }

    public static TypeDeclaration createTypeDeclaration(Class<?> cls, PropertySpecificOption propertySpecificOption) {
        Timestamp timestamp;
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean(cls, (PropertySpecificOption)propertySpecificOption);
        Duration duration = cls.getAnnotation(Duration.class);
        if (duration != null) {
            TypeDeclarationUtil.wireDurationAccessor(duration.value(), typeDeclaration);
        }
        if ((timestamp = cls.getAnnotation(Timestamp.class)) != null) {
            TypeDeclarationUtil.wireTimestampAccessor(timestamp.value(), typeDeclaration);
        }
        return typeDeclaration;
    }

    private static void wireDurationAccessor(String durationField, TypeDeclaration type) {
        type.setDurationAttribute(durationField);
        type.setDurationExtractor(TypeDeclarationUtil.getFieldExtractor(type, durationField, Long.TYPE));
    }

    private static void wireTimestampAccessor(String timestampField, TypeDeclaration type) {
        type.setTimestampAttribute(timestampField);
        type.setTimestampExtractor(TypeDeclarationUtil.getFieldExtractor(type, timestampField, Long.TYPE));
    }

    private static ReadAccessor getFieldExtractor(TypeDeclaration type, String field, Class<?> returnType) {
        return new LambdaReadAccessor(returnType, new LambdaFieldReader(type.getTypeClass(), field));
    }

    private TypeDeclarationUtil() {
    }

    public static class FieldDefinitionForModel
    extends FieldDefinition {
        private ClassDefinitionForModel classDef;
        private Field field;

        public FieldDefinitionForModel() {
        }

        public FieldDefinitionForModel(ClassDefinitionForModel classDef, Field field) {
            super(field.getName(), field.getGenericType().getTypeName());
            this.classDef = classDef;
            this.field = field;
            Position position = field.getAnnotation(Position.class);
            if (position != null) {
                this.setIndex(position.value());
            }
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public Object getValue(Object bean) {
            return this.classDef.get(bean, this.field.getName());
        }

        public void setValue(Object bean, Object value) {
            this.classDef.set(bean, this.field.getName(), value);
        }

        public Object get(Object bean) {
            return this.classDef.get(bean, this.field.getName());
        }

        public void set(Object bean, Object value) {
            this.classDef.set(bean, this.field.getName(), value);
        }
    }

    public static class AccessibleClassDefinition
    extends ClassDefinitionForModel {
        public AccessibleClassDefinition() {
        }

        public AccessibleClassDefinition(Class<?> cls, TypeResolver typeResolver) {
            super(cls);
            this.processAnnotations(cls, typeResolver);
        }

        private void processAnnotations(Class<?> cls, TypeResolver typeResolver) {
            for (Annotation ann : cls.getAnnotations()) {
                try {
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    Class annotationClass = null;
                    Object value = null;
                    for (Method m : ann.getClass().getMethods()) {
                        if (m.getParameterCount() != 0 || m.getReturnType() == Void.class || m.getDeclaringClass() == Object.class || m.getName().equals("hashCode") || m.getName().equals("toString")) continue;
                        if (m.getName().equals("annotationType")) {
                            annotationClass = (Class)m.invoke((Object)ann, new Object[0]);
                            continue;
                        }
                        valueMap.put(m.getName(), m.invoke((Object)ann, new Object[0]));
                        if (!m.getName().equals("value")) continue;
                        value = m.invoke((Object)ann, new Object[0]);
                    }
                    if (annotationClass == null) continue;
                    this.addAnnotation(AnnotationDefinition.build(annotationClass, valueMap, (TypeResolver)typeResolver));
                    if (value == null || !annotationClass.getCanonicalName().startsWith("org.kie.api.definition.type")) continue;
                    this.addMetaData(annotationClass.getSimpleName().toLowerCase(), value.toString().toLowerCase());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public Object get(Object bean, String field) {
            return ((AccessibleFact)bean).getValue(field);
        }

        public void set(Object bean, String field, Object value) {
            ((AccessibleFact)bean).setValue(field, value);
        }
    }

    public static class DynamicClassDefinition
    extends ClassDefinitionForModel {
        public DynamicClassDefinition() {
        }

        public DynamicClassDefinition(Class<?> cls) {
            super(cls);
        }

        public Object get(Object bean, String field) {
            Field f = ClassUtils.getField((Class)this.getDefinedClass(), (String)field);
            if (f != null) {
                f.setAccessible(true);
                try {
                    return f.get(bean);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        public void set(Object bean, String field, Object value) {
            Field f = ClassUtils.getField((Class)this.getDefinedClass(), (String)field);
            if (f != null) {
                f.setAccessible(true);
                try {
                    f.set(bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class ClassDefinitionForModel
    extends ClassDefinition {
        public ClassDefinitionForModel() {
        }

        public ClassDefinitionForModel(Class<?> cls) {
            super(cls);
        }

        public final FieldDefinition getField(String fieldName) {
            return this.fields.computeIfAbsent(fieldName, name -> {
                Field f = ClassUtils.getField((Class)this.getDefinedClass(), (String)name);
                return f == null ? null : new FieldDefinitionForModel(this, f);
            });
        }

        public Map<String, Object> getAsMap(Object bean) {
            HashMap<String, Object> m = new HashMap<String, Object>(this.fields.size());
            for (String field : this.fields.keySet()) {
                m.put(field, this.get(bean, field));
            }
            return m;
        }
    }
}

