/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.mvel.asm.DumpMethodVisitor;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.MethodVisitor;

public class LambdaIntrospector
implements Function<Object, String> {
    public static final String LAMBDA_INTROSPECTOR_CACHE_SIZE = "drools.lambda.introspector.cache.size";
    private static final int CACHE_SIZE = Integer.parseInt(System.getProperty("drools.lambda.introspector.cache.size", "32"));
    private static final Map<ClassLoader, ClassesFingerPrintsCache> methodFingerprintsMapPerClassLoader = Collections.synchronizedMap(new WeakHashMap());

    static Map<ClassLoader, ClassesFingerPrintsCache> getMethodFingerprintsMapPerClassLoader() {
        return methodFingerprintsMapPerClassLoader;
    }

    @Override
    public String apply(Object lambda) {
        SerializedLambda extracted;
        String result;
        if (lambda.toString().equals("INSTANCE")) {
            return LambdaIntrospector.getExpressionHash(lambda);
        }
        if (lambda instanceof Supplier) {
            lambda = ((Supplier)lambda).get();
        }
        if ((result = LambdaIntrospector.getFingerprintsForClass(lambda, extracted = LambdaIntrospector.extractLambda((Serializable)lambda)).get(extracted.getImplMethodName())) == null) {
            if (!extracted.getCapturingClass().equals(extracted.getImplClass())) {
                result = extracted.getCapturingClass().replace('/', '.') + "::" + extracted.getImplMethodName();
            } else {
                throw new UnsupportedOperationException("Unable to introspect lambda " + lambda);
            }
        }
        return result;
    }

    private static String getExpressionHash(Object lambda) {
        try {
            Field expressionHash = lambda.getClass().getDeclaredField("EXPRESSION_HASH");
            return (String)expressionHash.get(lambda);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static SerializedLambda extractLambda(Serializable lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke((Object)lambda, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodsFingerPrintsCache getFingerprintsForClass(Object lambda, SerializedLambda extracted) {
        ClassLoader lambdaClassLoader = lambda.getClass().getClassLoader();
        String className = extracted.getCapturingClass();
        if (CACHE_SIZE <= 0) {
            return MethodsFingerPrintsCache.getFingerPrints(lambdaClassLoader, className);
        }
        ClassesFingerPrintsCache methodFingerprintsMap = methodFingerprintsMapPerClassLoader.computeIfAbsent(lambdaClassLoader, ClassesFingerPrintsCache::new);
        return methodFingerprintsMap.registerMethodFingerPrints(className);
    }

    static class MethodsFingerPrintsCache {
        private final Map<String, String> map;

        private MethodsFingerPrintsCache(Map<String, String> map) {
            this.map = map;
        }

        private static MethodsFingerPrintsCache getFingerPrints(ClassLoader lambdaClassLoader, String className) {
            LambdaClassVisitor visitor = new LambdaClassVisitor();
            try (InputStream classStream = lambdaClassLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
                ClassReader reader = new ClassReader(classStream);
                reader.accept((ClassVisitor)visitor, 6);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new MethodsFingerPrintsCache(visitor.getMethodsMap());
        }

        public String get(String implMethodName) {
            return this.map.get(implMethodName);
        }
    }

    static class ClassesFingerPrintsCache {
        private final ClassLoader lambdaClassLoader;
        private final Map<String, MethodsFingerPrintsCache> map = Collections.synchronizedMap(new LinkedHashMap<String, MethodsFingerPrintsCache>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, MethodsFingerPrintsCache> eldest) {
                return this.size() > CACHE_SIZE;
            }
        });

        ClassesFingerPrintsCache(ClassLoader lambdaClassLoader) {
            this.lambdaClassLoader = lambdaClassLoader;
        }

        public MethodsFingerPrintsCache registerMethodFingerPrints(String className) {
            return this.map.computeIfAbsent(className, k -> MethodsFingerPrintsCache.getFingerPrints(this.lambdaClassLoader, className));
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class LambdaClassVisitor
    extends ClassVisitor {
        private final Map<String, String> methodsMap = new HashMap<String, String>();

        LambdaClassVisitor() {
            super(458752);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return name.startsWith("lambda$") ? new DumpMethodVisitor(s -> this.setMethodFingerprint(name, (String)s)) : super.visitMethod(access, name, desc, signature, exceptions);
        }

        void setMethodFingerprint(String methodname, String methodFingerprint) {
            this.methodsMap.put(methodname, methodFingerprint);
        }

        Map<String, String> getMethodsMap() {
            return this.methodsMap;
        }
    }
}

