/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.errors.ErrorHandler;
import org.drools.compiler.builder.impl.errors.FunctionErrorHandler;
import org.drools.compiler.builder.impl.errors.RuleErrorHandler;
import org.drools.compiler.builder.impl.errors.RuleInvokerErrorHandler;
import org.drools.compiler.builder.impl.errors.SrcErrorHandler;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.kie.builder.impl.CompilationProblemAdapter;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.WindowReferenceDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.CollectBuilder;
import org.drools.compiler.rule.builder.ConditionalBranchBuilder;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.EnabledBuilder;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.EntryPointBuilder;
import org.drools.compiler.rule.builder.ForallBuilder;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.FunctionBuilder;
import org.drools.compiler.rule.builder.GroupElementBuilder;
import org.drools.compiler.rule.builder.JavaRuleClassBuilder;
import org.drools.compiler.rule.builder.NamedConsequenceBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryBuilder;
import org.drools.compiler.rule.builder.ReturnValueBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleClassBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.compiler.rule.builder.WindowReferenceBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.core.addon.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.Function;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.LineMappings;
import org.drools.core.spi.Wireable;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.drools.mvel.asm.ASMConsequenceStubBuilder;
import org.drools.mvel.asm.ASMEvalStubBuilder;
import org.drools.mvel.asm.ASMPredicateStubBuilder;
import org.drools.mvel.asm.ASMReturnValueStubBuilder;
import org.drools.mvel.builder.MVELEnabledBuilder;
import org.drools.mvel.builder.MVELFromBuilder;
import org.drools.mvel.builder.MVELSalienceBuilder;
import org.drools.mvel.java.JavaAccumulateBuilder;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaExprAnalyzer;
import org.drools.mvel.java.JavaForMvelDialectConfiguration;
import org.drools.mvel.java.JavaFunctionBuilder;
import org.drools.mvel.java.PackageStore;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.jci.CompilationProblem;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.MemoryResourceReader;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

public class JavaDialect
implements Dialect {
    public static final String ID = "java";
    private static final String EXPRESSION_DIALECT_NAME = "mvel";
    protected static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static final QueryBuilder QUERY_BUILDER = new QueryBuilder();
    protected static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static final JavaAccumulateBuilder ACCUMULATE_BUILDER = new JavaAccumulateBuilder();
    protected static final RuleConditionBuilder EVAL_BUILDER = new ASMEvalStubBuilder();
    protected static final PredicateBuilder PREDICATE_BUILDER = new ASMPredicateStubBuilder();
    protected static final ReturnValueBuilder RETURN_VALUE_BUILDER = new ASMReturnValueStubBuilder();
    protected static final ConsequenceBuilder CONSEQUENCE_BUILDER = new ASMConsequenceStubBuilder();
    protected static final JavaRuleClassBuilder RULE_CLASS_BUILDER = new JavaRuleClassBuilder();
    protected static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static final CollectBuilder COLLECT_BUIDER = new CollectBuilder();
    protected static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static final WindowReferenceBuilder WINDOW_REFERENCE_BUILDER = new WindowReferenceBuilder();
    protected static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    protected static final NamedConsequenceBuilder NAMED_CONSEQUENCE_BUILDER = new NamedConsequenceBuilder();
    protected static final ConditionalBranchBuilder CONDITIONAL_BRANCH_BUILDER = new ConditionalBranchBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    private static final JavaExprAnalyzer analyzer;
    private final JavaForMvelDialectConfiguration configuration;
    private JavaCompiler compiler;
    private final InternalKnowledgePackage pkg;
    private final ClassLoader rootClassLoader;
    private final KnowledgeBuilderConfigurationImpl pkgConf;
    private final List<String> generatedClassList;
    private final MemoryResourceReader src;
    private final PackageStore packageStoreWrapper;
    private final Map<String, ErrorHandler> errorHandlers;
    private final List<KnowledgeBuilderResult> results;
    private final PackageRegistry packageRegistry;

    public JavaDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        this.rootClassLoader = rootClassLoader;
        this.pkgConf = pkgConf;
        this.pkg = pkg;
        this.packageRegistry = pkgRegistry;
        this.configuration = (JavaForMvelDialectConfiguration)pkgConf.getDialectConfiguration(ID);
        this.errorHandlers = new ConcurrentHashMap<String, ErrorHandler>();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.src = new MemoryResourceReader();
        this.generatedClassList = Collections.synchronizedList(new ArrayList());
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(ID);
        if (data == null) {
            data = new JavaDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(ID, (DialectRuntimeData)data);
            data.onAdd(this.pkg.getDialectRuntimeRegistry(), rootClassLoader);
        } else {
            data = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(ID);
        }
        this.packageStoreWrapper = new PackageStore(data, this.results);
        this.loadCompiler();
    }

    public static synchronized void initBuilder() {
        if (builders != null) {
            return;
        }
        JavaDialect.reinitBuilder();
    }

    public static synchronized void reinitBuilder() {
        builders = new HashMap();
        builders.put(CollectDescr.class, (EngineElementBuilder)COLLECT_BUIDER);
        builders.put(ForallDescr.class, (EngineElementBuilder)FORALL_BUILDER);
        builders.put(AndDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(OrDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(NotDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(ExistsDescr.class, (EngineElementBuilder)GE_BUILDER);
        builders.put(PatternDescr.class, (EngineElementBuilder)PATTERN_BUILDER);
        builders.put(QueryDescr.class, (EngineElementBuilder)QUERY_BUILDER);
        builders.put(FromDescr.class, (EngineElementBuilder)FROM_BUILDER);
        builders.put(AccumulateDescr.class, (EngineElementBuilder)ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, (EngineElementBuilder)EVAL_BUILDER);
        builders.put(EntryPointDescr.class, (EngineElementBuilder)ENTRY_POINT_BUILDER);
        builders.put(WindowReferenceDescr.class, (EngineElementBuilder)WINDOW_REFERENCE_BUILDER);
        builders.put(NamedConsequenceDescr.class, (EngineElementBuilder)NAMED_CONSEQUENCE_BUILDER);
        builders.put(ConditionalBranchDescr.class, (EngineElementBuilder)CONDITIONAL_BRANCH_BUILDER);
    }

    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    public void init(RuleDescr ruleDescr) {
        String ruleClassName = DialectUtil.getUniqueLegalName((String)this.pkg.getName(), (String)ruleDescr.getName(), (int)ruleDescr.getConsequence().hashCode(), (String)ID, (String)"Rule", (ResourceReader)this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
    }

    public void init(ProcessDescr processDescr) {
        String processDescrClassName = DialectUtil.getUniqueLegalName((String)this.pkg.getName(), (String)processDescr.getName(), (int)processDescr.getProcessId().hashCode(), (String)ID, (String)"Process", (ResourceReader)this.src);
        processDescr.setClassName(StringUtils.ucFirst((String)processDescrClassName));
    }

    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
        return this.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeExpression((String)content, availableIdentifiers);
        }
        catch (Exception e) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, (Object)e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeBlock(text, availableIdentifiers);
        }
        catch (Exception e) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, (Object)e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)builders.get(clazz);
    }

    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    public RuleClassBuilder getRuleClassBuilder() {
        return RULE_CLASS_BUILDER;
    }

    public FunctionBuilder getFunctionBuilder() {
        return FUNCTION_BUILDER;
    }

    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    public void compileAll() {
        CompilationResult result;
        if (this.generatedClassList.isEmpty()) {
            this.errorHandlers.clear();
            return;
        }
        String[] classes = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(classes);
        File dumpDir = this.configuration.getPackageBuilderConfiguration().getDumpDir();
        if (dumpDir != null) {
            this.dumpResources(classes, dumpDir);
        }
        if ((result = this.compiler.compile(classes, (ResourceReader)this.src, (ResourceStore)this.packageStoreWrapper, this.rootClassLoader)).getErrors().length > 0) {
            for (int i = 0; i < result.getErrors().length; ++i) {
                CompilationProblemAdapter err = new CompilationProblemAdapter(result.getErrors()[i]);
                ErrorHandler handler = this.errorHandlers.get(err.getFileName());
                handler.addError((CompilationProblem)err);
            }
            Collection<ErrorHandler> errors = this.errorHandlers.values();
            for (ErrorHandler error : errors) {
                ErrorHandler handler = error;
                if (!handler.isInError()) continue;
                this.results.add((KnowledgeBuilderResult)handler.getError());
            }
        }
        this.generatedClassList.clear();
        this.errorHandlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpResources(String[] classes, File dumpDir) {
        for (String aClass : classes) {
            File target = new File(dumpDir, aClass);
            FileOutputStream out = null;
            try {
                File parent = target.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                target.createNewFile();
                out = new FileOutputStream(target);
                out.write(this.src.getBytes(aClass));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void addRule(RuleBuildContext context) {
        RuleImpl rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        RuleClassBuilder classBuilder = context.getDialect().getRuleClassBuilder();
        String ruleClass = classBuilder.buildRule(context);
        if (ruleClass == null) {
            return;
        }
        this.addClassCompileTask(this.pkg.getName() + "." + ruleDescr.getClassName(), (BaseDescr)ruleDescr, ruleClass, this.src, (ErrorHandler)new RuleErrorHandler((BaseDescr)ruleDescr, rule, "Rule Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData(ID);
        for (Map.Entry invokers : context.getInvokers().entrySet()) {
            String className = (String)invokers.getKey();
            Object invoker = context.getInvokerLookup(className);
            if (invoker instanceof Wireable) {
                data.putInvoker(className, (Wireable)invoker);
            }
            String text = (String)invokers.getValue();
            BaseDescr descr = context.getDescrLookup(className);
            this.addClassCompileTask(className, descr, text, this.src, (ErrorHandler)new RuleInvokerErrorHandler(descr, rule, "Unable to generate rule invoker."));
        }
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst((String)functionDescr.getName());
        functionDescr.setClassName(functionClassName);
        this.pkg.addStaticImport(functionClassName + "." + functionDescr.getName());
        Function function = new Function(functionDescr.getNamespace(), functionDescr.getName(), ID);
        if (resource != null && ((InternalResource)resource).hasURL()) {
            function.setResource(resource);
        }
        this.pkg.addFunction(function);
        String functionSrc = this.getFunctionBuilder().build(this.pkg, functionDescr, typeResolver, this.pkg.getDialectRuntimeRegistry().getLineMappings(), this.results);
        this.addClassCompileTask(functionClassName, (BaseDescr)functionDescr, functionSrc, this.src, (ErrorHandler)new FunctionErrorHandler(functionDescr, "Function Compilation error"));
        LineMappings mapping = new LineMappings(functionClassName);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(functionClassName, mapping);
    }

    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst((String)functionDescr.getName());
        this.pkg.addStaticImport(functionClassName + "." + functionDescr.getName());
    }

    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst((String)functionDescr.getName());
        ImportDescr importDescr = new ImportDescr(functionClassName + "." + functionDescr.getName());
        importDescr.setResource(functionDescr.getResource());
        importDescr.setNamespace(functionDescr.getNamespace());
        this.packageRegistry.addStaticImport(importDescr);
    }

    public void addSrc(String resourceName, byte[] content) {
        this.src.add(resourceName, content);
        this.errorHandlers.put(resourceName, (ErrorHandler)new SrcErrorHandler("Src compile error"));
        this.addClassName(resourceName);
    }

    public void addClassCompileTask(String className, BaseDescr descr, String text, MemoryResourceReader src, ErrorHandler handler) {
        String fileName = className.replace('.', '/') + ".java";
        if (src != null) {
            src.add(fileName, text.getBytes(IoUtils.UTF8_CHARSET));
        } else {
            this.src.add(fileName, text.getBytes(IoUtils.UTF8_CHARSET));
        }
        this.errorHandlers.put(fileName, handler);
        this.addClassName(fileName);
    }

    public void addClassName(String className) {
        String resourceName;
        List bytecodes;
        Map cache;
        boolean found = false;
        if (this.pkgConf.isPreCompiled() && (cache = this.pkgConf.getCompilationCache().getCacheForDialect(ID)) != null && (bytecodes = (List)cache.get(resourceName = className.replace(".java", ".class"))) != null) {
            for (InternalKieModule.CompilationCacheEntry entry : bytecodes) {
                this.packageStoreWrapper.write(entry.className, entry.bytecode);
            }
            found = true;
        }
        if (!found) {
            this.generatedClassList.add(className);
        }
    }

    private void loadCompiler() {
        this.compiler = JavaCompilerFactory.loadCompiler((JavaConfiguration)this.configuration);
    }

    public void addImport(ImportDescr importDescr) {
    }

    public void addStaticImport(ImportDescr importDescr) {
    }

    public List<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
        this.errorHandlers.clear();
    }

    public String getId() {
        return ID;
    }

    public PackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    static {
        JavaDialect.initBuilder();
        analyzer = new JavaExprAnalyzer();
    }
}

