/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.drools.core.spi.Activation;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.executor.RuleUnitExecutorSession;
import org.drools.ruleunit.impl.Guard;

public class RuleUnitGuardSystem {
    private static final RuleUnit ROOT_UNIT = new RuleUnit(){};
    private final RuleUnitExecutorSession session;
    private Map<Guard, Guard> guardMap = new HashMap<Guard, Guard>();
    private Map<Activation, List<Guard>> guardsByActivation = new HashMap<Activation, List<Guard>>();
    private Map<RuleUnit, Set<Guard>> guardsByActivatingUnit = new HashMap<RuleUnit, Set<Guard>>();

    public RuleUnitGuardSystem(RuleUnitExecutorSession session) {
        this.session = session;
    }

    public void registerGuard(RuleUnit ruleUnit, Activation activation) {
        Guard g = new Guard(ruleUnit, activation.getRule());
        Guard guard = this.guardMap.computeIfAbsent(g, x -> g);
        guard.addActivation(activation);
        this.guardsByActivation.computeIfAbsent(activation, a -> new ArrayList()).add(guard);
        this.guardsByActivatingUnit.computeIfAbsent(this.getCurrentRuleUnit(), ru -> new HashSet()).add(guard);
    }

    public void removeActivation(Activation activation) {
        List<Guard> guards = this.guardsByActivation.get(activation);
        if (guards == null) {
            return;
        }
        guards.removeIf(guard -> {
            guard.removeActivation(activation);
            if (!guard.isActive()) {
                this.guardMap.remove(guard);
                this.guardsByActivatingUnit.computeIfPresent(this.getCurrentRuleUnit(), (s, gs) -> {
                    gs.remove(guard);
                    return gs.isEmpty() ? null : gs;
                });
                return true;
            }
            return false;
        });
        if (guards.isEmpty()) {
            this.guardsByActivation.remove(activation);
        }
    }

    private RuleUnit getCurrentRuleUnit() {
        return this.session.getCurrentRuleUnit() != null ? this.session.getCurrentRuleUnit() : ROOT_UNIT;
    }

    public int fireActiveUnits() {
        return this.fireActiveUnits(ROOT_UNIT);
    }

    public int fireActiveUnits(RuleUnit ruleUnit) {
        return this.fireActiveUnits(ruleUnit, new HashSet<RuleUnit>());
    }

    private int fireActiveUnits(RuleUnit ruleUnit, Set<RuleUnit> firedUnits) {
        Optional<RuleUnit> unit;
        Set<Guard> guards = this.guardsByActivatingUnit.get(ruleUnit);
        if (guards == null) {
            return 0;
        }
        int result = 0;
        while ((unit = guards.stream().map(Guard::getGuardedUnit).filter(u -> !firedUnits.contains(u)).findFirst()).isPresent()) {
            RuleUnit firingUnit = unit.get();
            result += this.session.internalExecuteUnit(firingUnit);
            firedUnits.add(firingUnit);
            result += this.fireActiveUnits(firingUnit, firedUnits);
        }
        return result;
    }
}

