/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import org.drools.base.rule.EntryPointId;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.DoubleLinkedEntry;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.kiesession.consequence.DefaultKnowledgeHelper;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.TruthMaintenanceSystemImpl;
import org.drools.tms.agenda.TruthMaintenanceSystemInternalMatch;
import org.drools.tms.agenda.TruthMaintenanceSystemRuleTerminalNodeLeftTuple;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.BeliefSystemMode;
import org.drools.tms.beliefsystem.ModedAssertion;
import org.drools.tms.beliefsystem.simple.SimpleLogicalDependency;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.Match;

public class TruthMaintenanceSystemKnowledgeHelper<T extends ModedAssertion<T>>
extends DefaultKnowledgeHelper {
    private LinkedList<LogicalDependency<T>> previousJustified;
    private LinkedList<LogicalDependency<SimpleMode>> previousBlocked;

    public TruthMaintenanceSystemKnowledgeHelper() {
    }

    public TruthMaintenanceSystemKnowledgeHelper(ReteEvaluator reteEvaluator) {
        super(reteEvaluator);
    }

    public void setActivation(InternalMatch internalMatch) {
        TruthMaintenanceSystemInternalMatch tmsActivation = (TruthMaintenanceSystemInternalMatch)internalMatch;
        this.previousJustified = tmsActivation.getLogicalDependencies();
        this.previousBlocked = tmsActivation.getBlocked();
        super.setActivation(internalMatch);
        tmsActivation.setLogicalDependencies(null);
        tmsActivation.setBlocked(null);
    }

    public void restoreActivationOnConsequenceFailure(InternalMatch internalMatch) {
        TruthMaintenanceSystemInternalMatch tmsActivation = (TruthMaintenanceSystemInternalMatch)internalMatch;
        tmsActivation.setLogicalDependencies(this.previousJustified);
        tmsActivation.setBlocked(tmsActivation.getBlocked());
    }

    public void reset() {
        this.cancelRemainingPreviousLogicalDependencies();
        super.reset();
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public InternalFactHandle insertLogical(Object object, Object value) {
        return this.insertLogical((EntryPoint)this.toStatefulKnowledgeSession().getDefaultEntryPoint(), object, value);
    }

    public InternalFactHandle insertLogical(EntryPoint entryPoint, Object object) {
        return this.insertLogical(entryPoint, object, null);
    }

    public InternalFactHandle insertLogical(EntryPoint entryPoint, Object object, Object value) {
        if (object == null) {
            return null;
        }
        if (!this.internalMatch.isMatched()) {
            return null;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = (LogicalDependency)this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove((DoubleLinkedEntry)dep);
                break;
            }
        }
        if (dep != null) {
            ((TruthMaintenanceSystemInternalMatch)this.internalMatch).addLogicalDependency(dep);
            return ((BeliefSet)dep.getJustified()).getFactHandle();
        }
        return TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)entryPoint).insert(object, value, this.internalMatch);
    }

    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = (LogicalDependency)this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemImpl.removeLogicalDependency(dep, this.internalMatch.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = (LogicalDependency)this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove((DoubleLinkedEntry)dep);
                TruthMaintenanceSystemInternalMatch justified = (TruthMaintenanceSystemInternalMatch)dep.getJustified();
                justified.getBlockers().remove(dep.getMode());
                if (justified.getBlockers().isEmpty()) {
                    RuleAgendaItem ruleAgendaItem = justified.getRuleAgendaItem();
                    this.toStatefulKnowledgeSession().getAgenda().stageLeftTuple(ruleAgendaItem, (InternalMatch)justified);
                }
                dep = tmp;
            }
        }
    }

    public InternalFactHandle bolster(Object object, Object value) {
        BeliefSystem beliefSystem;
        if (object == null || !this.internalMatch.isMatched()) {
            return null;
        }
        InternalFactHandle handle = this.getFactHandleFromWM(object);
        NamedEntryPoint ep = (NamedEntryPoint)this.reteEvaluator.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        ObjectTypeConf otc = ep.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(ep.getEntryPoint(), object);
        BeliefSet beliefSet = null;
        if (handle == null) {
            handle = RuntimeComponentFactory.get().getFactHandleFactoryService().newFactHandle(object, otc, this.reteEvaluator, (WorkingMemoryEntryPoint)ep);
        }
        if (handle.getEqualityKey() == null) {
            handle.setEqualityKey((EqualityKey)new TruthMaintenanceSystemEqualityKey(handle, 1));
        } else {
            beliefSet = ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).getBeliefSet();
        }
        BeliefSystem beliefSystem2 = beliefSystem = value instanceof BeliefSystemMode ? ((BeliefSystemMode)value).getBeliefSystem() : ((TruthMaintenanceSystemImpl)TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.toStatefulKnowledgeSession())).getBeliefSystem();
        if (beliefSet == null) {
            beliefSet = beliefSystem.newBeliefSet(handle);
            ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).setBeliefSet(beliefSet);
        }
        return beliefSystem.insert(beliefSystem.asMode(value), this.internalMatch.getRule(), (TruthMaintenanceSystemInternalMatch)this.internalMatch, object, beliefSet, this.internalMatch.getPropagationContext(), otc).getFactHandle();
    }

    public void blockMatch(Match act) {
        TruthMaintenanceSystemRuleTerminalNodeLeftTuple targetMatch = (TruthMaintenanceSystemRuleTerminalNodeLeftTuple)act;
        SimpleLogicalDependency<SimpleMode> dep = null;
        if (this.previousBlocked != null) {
            for (dep = (SimpleLogicalDependency<SimpleMode>)this.previousBlocked.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousBlocked.remove((DoubleLinkedEntry)dep);
                break;
            }
        }
        if (dep == null) {
            SimpleMode mode = new SimpleMode();
            dep = new SimpleLogicalDependency<SimpleMode>((TruthMaintenanceSystemInternalMatch)this.internalMatch, targetMatch, mode);
            mode.setObject(dep);
        }
        ((TruthMaintenanceSystemInternalMatch)this.internalMatch).addBlocked((LogicalDependency<SimpleMode>)dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isQueued()) {
            targetMatch.remove();
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation((InternalMatch)targetMatch);
            }
        }
    }

    public void unblockAllMatches(Match act) {
        TruthMaintenanceSystemRuleTerminalNodeLeftTuple targetMatch = (TruthMaintenanceSystemRuleTerminalNodeLeftTuple)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = (LinkedListEntry)targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = (LogicalDependency)entry.getObject();
            dep.getJustifier().removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            RuleAgendaItem ruleAgendaItem = targetMatch.getRuleAgendaItem();
            InternalAgenda agenda = this.toStatefulKnowledgeSession().getAgenda();
            agenda.stageLeftTuple(ruleAgendaItem, (InternalMatch)targetMatch);
        }
    }
}

