/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.dynamic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.kie.internal.utils.FastClassLoader;
import org.kie.memorycompiler.WritableClassLoader;

public class PackageClassLoader
extends ClassLoader
implements FastClassLoader,
WritableClassLoader {
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(() -> PackageClassLoader.class.getProtectionDomain());
    private final ConcurrentHashMap<String, Object> parallelLockMap = new ConcurrentHashMap();
    protected Map<String, byte[]> store;
    private Set<String> existingPackages = new ConcurrentSkipListSet<String>();

    public PackageClassLoader(Map<String, byte[]> store, ClassLoader rootClassLoader) {
        super(rootClassLoader);
        this.store = store;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (cls == null) {
            ClassLoader parent = this.getParent();
            cls = parent.loadClass(name);
        }
        if (cls == null) {
            throw new ClassNotFoundException("Unable to load class: " + name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> fastFindClass(String name) {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            Object lock;
            Object object = lock = this.getLockObject(name);
            synchronized (object) {
                cls = this.findLoadedClass(name);
                if (cls == null) {
                    try {
                        cls = this.internalDefineClass(name, this.store.get(PackageClassLoader.convertClassToResourcePath(name)));
                    }
                    finally {
                        this.releaseLockObject(name);
                    }
                }
            }
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> internalDefineClass(String name, byte[] clazzBytes) {
        if (clazzBytes == null) {
            return null;
        }
        String pkgName = name.substring(0, name.lastIndexOf(46));
        if (!this.existingPackages.contains(pkgName)) {
            PackageClassLoader packageClassLoader = this;
            synchronized (packageClassLoader) {
                if (this.getPackage(pkgName) == null) {
                    this.definePackage(pkgName, "", "", "", "", "", "", null);
                }
                this.existingPackages.add(pkgName);
            }
        }
        Class<?> cls = this.writeClass(name, clazzBytes);
        this.resolveClass(cls);
        return cls;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] clsBytes = this.store.get(name);
        return clsBytes != null ? new ByteArrayInputStream(clsBytes) : this.getParent().getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        return this.getParent().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getParent().getResources(name);
    }

    private Object getLockObject(String className) {
        Object newLock = new Object();
        Object lock = this.parallelLockMap.putIfAbsent(className, newLock);
        return lock != null ? lock : newLock;
    }

    private void releaseLockObject(String className) {
        this.parallelLockMap.remove(className);
    }

    public Class<?> writeClass(String name, byte[] bytecode) {
        return this.defineClass(name, bytecode, 0, bytecode.length, PROTECTION_DOMAIN);
    }

    private static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

