/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public final class Request {
    static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;
    private final String method;
    private final String endpoint;
    private final Map<String, String> parameters;
    private final HttpEntity entity;

    public Request(String method, String endpoint, Map<String, String> parameters, HttpEntity entity) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint cannot be null");
        this.parameters = Objects.requireNonNull(parameters, "parameters cannot be null");
        this.entity = entity;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public String toString() {
        return "Request{method='" + this.method + '\'' + ", endpoint='" + this.endpoint + '\'' + ", params=" + this.parameters + ", hasBody=" + (this.entity != null) + '}';
    }

    static Request delete(DeleteRequest deleteRequest) {
        String endpoint = Request.endpoint(deleteRequest.index(), deleteRequest.type(), deleteRequest.id());
        Params parameters = Params.builder();
        parameters.withRouting(deleteRequest.routing());
        parameters.withParent(deleteRequest.parent());
        parameters.withTimeout(deleteRequest.timeout());
        parameters.withVersion(deleteRequest.version());
        parameters.withVersionType(deleteRequest.versionType());
        parameters.withRefreshPolicy(deleteRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(deleteRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        return new Request("DELETE", endpoint, parameters.getParams(), null);
    }

    static Request deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        String endpoint = Request.endpoint(deleteIndexRequest.indices());
        Params parameters = Params.builder();
        parameters.withTimeout(deleteIndexRequest.timeout());
        parameters.withMasterTimeout(deleteIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(deleteIndexRequest.indicesOptions());
        return new Request("DELETE", endpoint, parameters.getParams(), null);
    }

    static Request openIndex(OpenIndexRequest openIndexRequest) {
        String endpoint = Request.endpoint(openIndexRequest.indices(), "_open");
        Params parameters = Params.builder();
        parameters.withTimeout(openIndexRequest.timeout());
        parameters.withMasterTimeout(openIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(openIndexRequest.waitForActiveShards(), ActiveShardCount.NONE);
        parameters.withIndicesOptions(openIndexRequest.indicesOptions());
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request closeIndex(CloseIndexRequest closeIndexRequest) {
        String endpoint = Request.endpoint(closeIndexRequest.indices(), "_close");
        Params parameters = Params.builder();
        parameters.withTimeout(closeIndexRequest.timeout());
        parameters.withMasterTimeout(closeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(closeIndexRequest.indicesOptions());
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = Request.endpoint(createIndexRequest.indices());
        Params parameters = Params.builder();
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.withUpdateAllTypes(createIndexRequest.updateAllTypes());
        HttpEntity entity = Request.createEntity((ToXContent)createIndexRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("PUT", endpoint, parameters.getParams(), entity);
    }

    static Request updateAliases(IndicesAliasesRequest indicesAliasesRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(indicesAliasesRequest.timeout());
        parameters.withMasterTimeout(indicesAliasesRequest.masterNodeTimeout());
        HttpEntity entity = Request.createEntity((ToXContent)indicesAliasesRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("POST", "/_aliases", parameters.getParams(), entity);
    }

    static Request putMapping(PutMappingRequest putMappingRequest) throws IOException {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        String endpoint = Request.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type());
        Params parameters = Params.builder();
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        parameters.withUpdateAllTypes(putMappingRequest.updateAllTypes());
        HttpEntity entity = Request.createEntity((ToXContent)putMappingRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("PUT", endpoint, parameters.getParams(), entity);
    }

    static Request refresh(RefreshRequest refreshRequest) {
        String[] indices = refreshRequest.indices() == null ? Strings.EMPTY_ARRAY : refreshRequest.indices();
        String endpoint = Request.endpoint(indices, "_refresh");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(refreshRequest.indicesOptions());
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request flush(FlushRequest flushRequest) {
        String[] indices = flushRequest.indices() == null ? Strings.EMPTY_ARRAY : flushRequest.indices();
        String endpoint = Request.endpoint(indices, "_flush");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(flushRequest.indicesOptions());
        parameters.putParam("wait_if_ongoing", Boolean.toString(flushRequest.waitIfOngoing()));
        parameters.putParam("force", Boolean.toString(flushRequest.force()));
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request forceMerge(ForceMergeRequest forceMergeRequest) {
        String[] indices = forceMergeRequest.indices() == null ? Strings.EMPTY_ARRAY : forceMergeRequest.indices();
        String endpoint = Request.endpoint(indices, "_forcemerge");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(forceMergeRequest.indicesOptions());
        parameters.putParam("max_num_segments", Integer.toString(forceMergeRequest.maxNumSegments()));
        parameters.putParam("only_expunge_deletes", Boolean.toString(forceMergeRequest.onlyExpungeDeletes()));
        parameters.putParam("flush", Boolean.toString(forceMergeRequest.flush()));
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest) {
        String[] indices = clearIndicesCacheRequest.indices() == null ? Strings.EMPTY_ARRAY : clearIndicesCacheRequest.indices();
        String endpoint = Request.endpoint(indices, "_cache/clear");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(clearIndicesCacheRequest.indicesOptions());
        parameters.putParam("query", Boolean.toString(clearIndicesCacheRequest.queryCache()));
        parameters.putParam("fielddata", Boolean.toString(clearIndicesCacheRequest.fieldDataCache()));
        parameters.putParam("request", Boolean.toString(clearIndicesCacheRequest.requestCache()));
        parameters.putParam("fields", String.join((CharSequence)",", clearIndicesCacheRequest.fields()));
        return new Request("POST", endpoint, parameters.getParams(), null);
    }

    static Request info() {
        return new Request("GET", "/", Collections.emptyMap(), null);
    }

    static Request bulk(BulkRequest bulkRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest request = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = request.opType();
            if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                bulkContentType = Request.enforceSameContentType((IndexRequest)request, bulkContentType);
                continue;
            }
            if (opType != DocWriteRequest.OpType.UPDATE) continue;
            UpdateRequest updateRequest = (UpdateRequest)request;
            if (updateRequest.doc() != null) {
                bulkContentType = Request.enforceSameContentType(updateRequest.doc(), bulkContentType);
            }
            if (updateRequest.upsertRequest() == null) continue;
            bulkContentType = Request.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = Request.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest request : bulkRequest.requests()) {
            BytesRef source;
            block44: {
                DocWriteRequest.OpType opType = request.opType();
                try (XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                    VersionType versionType;
                    metadata.startObject();
                    metadata.startObject(opType.getLowercase());
                    if (Strings.hasLength((String)request.index())) {
                        metadata.field("_index", request.index());
                    }
                    if (Strings.hasLength((String)request.type())) {
                        metadata.field("_type", request.type());
                    }
                    if (Strings.hasLength((String)request.id())) {
                        metadata.field("_id", request.id());
                    }
                    if (Strings.hasLength((String)request.routing())) {
                        metadata.field("routing", request.routing());
                    }
                    if (Strings.hasLength((String)request.parent())) {
                        metadata.field("parent", request.parent());
                    }
                    if (request.version() != -3L) {
                        metadata.field("version", request.version());
                    }
                    if ((versionType = request.versionType()) != VersionType.INTERNAL) {
                        if (versionType == VersionType.EXTERNAL) {
                            metadata.field("version_type", "external");
                        } else if (versionType == VersionType.EXTERNAL_GTE) {
                            metadata.field("version_type", "external_gte");
                        } else if (versionType == VersionType.FORCE) {
                            metadata.field("version_type", "force");
                        }
                    }
                    if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                        IndexRequest indexRequest = (IndexRequest)request;
                        if (Strings.hasLength((String)indexRequest.getPipeline())) {
                            metadata.field("pipeline", indexRequest.getPipeline());
                        }
                    } else if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)request;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                    metadata.endObject();
                    metadata.endObject();
                    BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                    content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                    content.write(separator);
                }
                source = null;
                if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                    IndexRequest indexRequest = (IndexRequest)request;
                    BytesReference indexSource = indexRequest.source();
                    XContentType indexXContentType = indexRequest.getContentType();
                    try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)indexSource, (XContentType)indexXContentType);
                         XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                        break block44;
                    }
                }
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)request), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        ByteArrayEntity entity = new ByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType);
        return new Request("POST", "/_bulk", parameters.getParams(), (HttpEntity)entity);
    }

    static Request exists(GetRequest getRequest) {
        Request request = Request.get(getRequest);
        return new Request("HEAD", request.endpoint, request.parameters, null);
    }

    static Request get(GetRequest getRequest) {
        String endpoint = Request.endpoint(getRequest.index(), getRequest.type(), getRequest.id());
        Params parameters = Params.builder();
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withParent(getRequest.parent());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        parameters.withStoredFields(getRequest.storedFields());
        parameters.withVersion(getRequest.version());
        parameters.withVersionType(getRequest.versionType());
        parameters.withFetchSourceContext(getRequest.fetchSourceContext());
        return new Request("GET", endpoint, parameters.getParams(), null);
    }

    static Request multiGet(MultiGetRequest multiGetRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withPreference(multiGetRequest.preference());
        parameters.withRealtime(multiGetRequest.realtime());
        parameters.withRefresh(multiGetRequest.refresh());
        HttpEntity entity = Request.createEntity((ToXContent)multiGetRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("POST", "/_mget", parameters.getParams(), entity);
    }

    static Request index(IndexRequest indexRequest) {
        String method = Strings.hasLength((String)indexRequest.id()) ? "PUT" : "POST";
        boolean isCreate = indexRequest.opType() == DocWriteRequest.OpType.CREATE;
        String endpoint = Request.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id(), isCreate ? "_create" : null);
        Params parameters = Params.builder();
        parameters.withRouting(indexRequest.routing());
        parameters.withParent(indexRequest.parent());
        parameters.withTimeout(indexRequest.timeout());
        parameters.withVersion(indexRequest.version());
        parameters.withVersionType(indexRequest.versionType());
        parameters.withPipeline(indexRequest.getPipeline());
        parameters.withRefreshPolicy(indexRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(indexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        BytesRef source = indexRequest.source().toBytesRef();
        ContentType contentType = Request.createContentType(indexRequest.getContentType());
        ByteArrayEntity entity = new ByteArrayEntity(source.bytes, source.offset, source.length, contentType);
        return new Request(method, endpoint, parameters.getParams(), (HttpEntity)entity);
    }

    static Request ping() {
        return new Request("HEAD", "/", Collections.emptyMap(), null);
    }

    static Request update(UpdateRequest updateRequest) throws IOException {
        String endpoint = Request.endpoint(updateRequest.index(), updateRequest.type(), updateRequest.id(), "_update");
        Params parameters = Params.builder();
        parameters.withRouting(updateRequest.routing());
        parameters.withParent(updateRequest.parent());
        parameters.withTimeout(updateRequest.timeout());
        parameters.withRefreshPolicy(updateRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(updateRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.withDocAsUpsert(updateRequest.docAsUpsert());
        parameters.withFetchSourceContext(updateRequest.fetchSource());
        parameters.withRetryOnConflict(updateRequest.retryOnConflict());
        parameters.withVersion(updateRequest.version());
        parameters.withVersionType(updateRequest.versionType());
        XContentType xContentType = null;
        if (updateRequest.doc() != null) {
            xContentType = updateRequest.doc().getContentType();
        }
        if (updateRequest.upsertRequest() != null) {
            XContentType upsertContentType = updateRequest.upsertRequest().getContentType();
            if (xContentType != null && xContentType != upsertContentType) {
                throw new IllegalStateException("Update request cannot have different content types for doc [" + xContentType + "] and upsert [" + upsertContentType + "] documents");
            }
            xContentType = upsertContentType;
        }
        if (xContentType == null) {
            xContentType = Requests.INDEX_CONTENT_TYPE;
        }
        HttpEntity entity = Request.createEntity((ToXContent)updateRequest, xContentType);
        return new Request("POST", endpoint, parameters.getParams(), entity);
    }

    static Request search(SearchRequest searchRequest) throws IOException {
        String endpoint = Request.endpoint(searchRequest.indices(), searchRequest.types(), "_search");
        Params params = Params.builder();
        params.putParam("typed_keys", "true");
        params.withRouting(searchRequest.routing());
        params.withPreference(searchRequest.preference());
        params.withIndicesOptions(searchRequest.indicesOptions());
        params.putParam("search_type", searchRequest.searchType().name().toLowerCase(Locale.ROOT));
        if (searchRequest.requestCache() != null) {
            params.putParam("request_cache", Boolean.toString(searchRequest.requestCache()));
        }
        if (searchRequest.allowPartialSearchResults() != null) {
            params.putParam("allow_partial_search_results", Boolean.toString(searchRequest.allowPartialSearchResults()));
        }
        params.putParam("batched_reduce_size", Integer.toString(searchRequest.getBatchedReduceSize()));
        if (searchRequest.scroll() != null) {
            params.putParam("scroll", searchRequest.scroll().keepAlive());
        }
        HttpEntity entity = null;
        if (searchRequest.source() != null) {
            entity = Request.createEntity((ToXContent)searchRequest.source(), REQUEST_BODY_CONTENT_TYPE);
        }
        return new Request("POST", endpoint, params.getParams(), entity);
    }

    static Request searchScroll(SearchScrollRequest searchScrollRequest) throws IOException {
        HttpEntity entity = Request.createEntity((ToXContent)searchScrollRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("POST", "/_search/scroll", Collections.emptyMap(), entity);
    }

    static Request clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        HttpEntity entity = Request.createEntity((ToXContent)clearScrollRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("DELETE", "/_search/scroll", Collections.emptyMap(), entity);
    }

    static Request multiSearch(MultiSearchRequest multiSearchRequest) throws IOException {
        Params params = Params.builder();
        params.putParam("typed_keys", "true");
        if (multiSearchRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchRequest.writeMultiLineFormat((MultiSearchRequest)multiSearchRequest, (XContent)xContent);
        ByteArrayEntity entity = new ByteArrayEntity(source, Request.createContentType(xContent.type()));
        return new Request("POST", "/_msearch", params.getParams(), (HttpEntity)entity);
    }

    static Request existsAlias(GetAliasesRequest getAliasesRequest) {
        Params params = Params.builder();
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        if (!(getAliasesRequest.indices() != null && getAliasesRequest.indices().length != 0 || getAliasesRequest.aliases() != null && getAliasesRequest.aliases().length != 0)) {
            throw new IllegalArgumentException("existsAlias requires at least an alias or an index");
        }
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        String endpoint = Request.endpoint(indices, "_alias", aliases);
        return new Request("HEAD", endpoint, params.getParams(), null);
    }

    static Request rankEval(RankEvalRequest rankEvalRequest) throws IOException {
        String endpoint = Request.endpoint(rankEvalRequest.indices(), Strings.EMPTY_ARRAY, "_rank_eval");
        Params params = Params.builder();
        params.withIndicesOptions(rankEvalRequest.indicesOptions());
        HttpEntity entity = Request.createEntity((ToXContent)rankEvalRequest.getRankEvalSpec(), REQUEST_BODY_CONTENT_TYPE);
        return new Request("GET", endpoint, params.getParams(), entity);
    }

    static Request split(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SPLIT) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices split request");
        }
        return Request.resize(resizeRequest);
    }

    static Request shrink(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SHRINK) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices shrink request");
        }
        return Request.resize(resizeRequest);
    }

    private static Request resize(ResizeRequest resizeRequest) throws IOException {
        Params params = Params.builder();
        params.withTimeout(resizeRequest.timeout());
        params.withMasterTimeout(resizeRequest.masterNodeTimeout());
        params.withWaitForActiveShards(resizeRequest.getTargetIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        String endpoint = new EndpointBuilder().addPathPart(resizeRequest.getSourceIndex()).addPathPartAsIs("_" + resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT)).addPathPart(resizeRequest.getTargetIndexRequest().index()).build();
        HttpEntity entity = Request.createEntity((ToXContent)resizeRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("PUT", endpoint, params.getParams(), entity);
    }

    static Request clusterPutSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(clusterUpdateSettingsRequest.timeout());
        parameters.withMasterTimeout(clusterUpdateSettingsRequest.masterNodeTimeout());
        HttpEntity entity = Request.createEntity((ToXContent)clusterUpdateSettingsRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("PUT", "/_cluster/settings", parameters.getParams(), entity);
    }

    static Request rollover(RolloverRequest rolloverRequest) throws IOException {
        Params params = Params.builder();
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        String endpoint = new EndpointBuilder().addPathPart(rolloverRequest.getAlias()).addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        HttpEntity entity = Request.createEntity((ToXContent)rolloverRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("POST", endpoint, params.getParams(), entity);
    }

    static Request indicesExist(GetIndexRequest request) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = Request.endpoint(request.indices(), "");
        Params params = Params.builder();
        params.withLocal(request.local());
        params.withHuman(request.humanReadable());
        params.withIndicesOptions(request.indicesOptions());
        params.withIncludeDefaults(request.includeDefaults());
        return new Request("HEAD", endpoint, params.getParams(), null);
    }

    static Request indexPutSettings(UpdateSettingsRequest updateSettingsRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(updateSettingsRequest.timeout());
        parameters.withMasterTimeout(updateSettingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(updateSettingsRequest.indicesOptions());
        parameters.withPreserveExisting(updateSettingsRequest.isPreserveExisting());
        String[] indices = updateSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : updateSettingsRequest.indices();
        String endpoint = Request.endpoint(indices, "_settings");
        HttpEntity entity = Request.createEntity((ToXContent)updateSettingsRequest, REQUEST_BODY_CONTENT_TYPE);
        return new Request("PUT", endpoint, parameters.getParams(), entity);
    }

    private static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType) throws IOException {
        BytesRef source = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (boolean)false).toBytesRef();
        return new ByteArrayEntity(source.bytes, source.offset, source.length, Request.createContentType(xContentType));
    }

    static String endpoint(String index, String type, String id) {
        return new EndpointBuilder().addPathPart(index, type, id).build();
    }

    static String endpoint(String index, String type, String id, String endpoint) {
        return new EndpointBuilder().addPathPart(index, type, id).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).build();
    }

    static String endpoint(String[] indices, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String[] types, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addCommaSeparatedPathParts(types).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String endpoint, String[] suffixes) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addCommaSeparatedPathParts(suffixes).build();
    }

    static String endpoint(String[] indices, String endpoint, String type) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addPathPart(type).build();
    }

    @SuppressForbidden(reason="Only allowed place to convert a XContentType to a ContentType")
    public static ContentType createContentType(XContentType xContentType) {
        return ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)null);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + requestContentType + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + requestContentType + "], previous requests have content-type [" + xContentType + "]");
        }
        return xContentType;
    }

    static class EndpointBuilder {
        private final StringJoiner joiner = new StringJoiner("/", "/", "");

        EndpointBuilder() {
        }

        EndpointBuilder addPathPart(String ... parts) {
            for (String part : parts) {
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(EndpointBuilder.encodePart(part));
            }
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(String[] parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addPathPartAsIs(String part) {
            if (Strings.hasLength((String)part)) {
                this.joiner.add(part);
            }
            return this;
        }

        String build() {
            return this.joiner.toString();
        }

        private static String encodePart(String pathPart) {
            try {
                URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                return uri.getRawPath().substring(1).replaceAll("/", "%2F");
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Path part [" + pathPart + "] couldn't be encoded", e);
            }
        }
    }

    static class Params {
        private final Map<String, String> params = new HashMap<String, String>();

        private Params() {
        }

        Params putParam(String key, String value) {
            if (Strings.hasLength((String)value) && this.params.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("Request parameter [" + key + "] is already registered");
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            if (value != null) {
                return this.putParam(key, value.getStringRep());
            }
            return this;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            if (docAsUpsert) {
                return this.putParam("doc_as_upsert", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_include", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_exclude", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withParent(String parent) {
            return this.putParam("parent", parent);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            if (!realtime) {
                return this.putParam("realtime", Boolean.FALSE.toString());
            }
            return this;
        }

        Params withRefresh(boolean refresh) {
            if (refresh) {
                return this.withRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            return this;
        }

        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            if (refreshPolicy != WriteRequest.RefreshPolicy.NONE) {
                return this.putParam("refresh", refreshPolicy.getValue());
            }
            return this;
        }

        Params withRetryOnConflict(int retryOnConflict) {
            if (retryOnConflict > 0) {
                return this.putParam("retry_on_conflict", String.valueOf(retryOnConflict));
            }
            return this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withStoredFields(String[] storedFields) {
            if (storedFields != null && storedFields.length > 0) {
                return this.putParam("stored_fields", String.join((CharSequence)",", storedFields));
            }
            return this;
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withUpdateAllTypes(boolean updateAllTypes) {
            if (updateAllTypes) {
                return this.putParam("update_all_types", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withVersion(long version) {
            if (version != -3L) {
                return this.putParam("version", Long.toString(version));
            }
            return this;
        }

        Params withVersionType(VersionType versionType) {
            if (versionType != VersionType.INTERNAL) {
                return this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withWaitForActiveShards(ActiveShardCount currentActiveShardCount, ActiveShardCount defaultActiveShardCount) {
            if (currentActiveShardCount != null && currentActiveShardCount != defaultActiveShardCount) {
                return this.putParam("wait_for_active_shards", currentActiveShardCount.toString().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            String expandWildcards;
            this.putParam("ignore_unavailable", Boolean.toString(indicesOptions.ignoreUnavailable()));
            this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
            if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                expandWildcards = "none";
            } else {
                StringJoiner joiner = new StringJoiner(",");
                if (indicesOptions.expandWildcardsOpen()) {
                    joiner.add("open");
                }
                if (indicesOptions.expandWildcardsClosed()) {
                    joiner.add("closed");
                }
                expandWildcards = joiner.toString();
            }
            this.putParam("expand_wildcards", expandWildcards);
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", Boolean.toString(human));
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", Boolean.toString(local));
            }
            return this;
        }

        Params withFlatSettings(boolean flatSettings) {
            if (flatSettings) {
                return this.putParam("flat_settings", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            if (includeDefaults) {
                return this.putParam("include_defaults", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            if (preserveExisting) {
                return this.putParam("preserve_existing", Boolean.TRUE.toString());
            }
            return this;
        }

        Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }

        static Params builder() {
            return new Params();
        }
    }
}

