/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RollupRequestConverters;
import org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.elasticsearch.client.rollup.GetRollupCapsResponse;
import org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupJobResponse;
import org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.elasticsearch.client.rollup.PutRollupJobResponse;

public class RollupClient {
    private final RestHighLevelClient restHighLevelClient;

    RollupClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutRollupJobResponse putRollupJob(PutRollupJobRequest request, RequestOptions options) throws IOException {
        return (PutRollupJobResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::putJob, options, PutRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, ActionListener<PutRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::putJob, options, PutRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupJobResponse getRollupJob(GetRollupJobRequest request, RequestOptions options) throws IOException {
        return (GetRollupJobResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, ActionListener<GetRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupCapsResponse getRollupCapabilities(GetRollupCapsRequest request, RequestOptions options) throws IOException {
        return (GetRollupCapsResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, ActionListener<GetRollupCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, listener, Collections.emptySet());
    }
}

