/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.rollup.RollableIndexCaps;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetRollupCapsResponse
implements ToXContentObject {
    private final Map<String, RollableIndexCaps> jobs;

    public GetRollupCapsResponse(Map<String, RollableIndexCaps> jobs) {
        this.jobs = Collections.unmodifiableMap(Objects.requireNonNull(jobs));
    }

    public Map<String, RollableIndexCaps> getJobs() {
        return this.jobs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, RollableIndexCaps> entry : this.jobs.entrySet()) {
            entry.getValue().toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static GetRollupCapsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, RollableIndexCaps> jobs = new HashMap<String, RollableIndexCaps>();
        XContentParser.Token token = parser.nextToken();
        if (token.equals((Object)XContentParser.Token.START_OBJECT)) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (!token.equals((Object)XContentParser.Token.FIELD_NAME)) continue;
                String pattern = parser.currentName();
                RollableIndexCaps cap = (RollableIndexCaps)RollableIndexCaps.PARSER.apply(pattern).apply(parser, null);
                jobs.put(pattern, cap);
            }
        }
        return new GetRollupCapsResponse(jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupCapsResponse other = (GetRollupCapsResponse)obj;
        return Objects.equals(this.jobs, other.jobs);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }
}

