/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.feature;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetFeaturesResponse {
    private final List<SnapshottableFeature> features;
    private static final ParseField FEATURES = new ParseField("features", new String[0]);
    private static final ConstructingObjectParser<GetFeaturesResponse, Void> PARSER = new ConstructingObjectParser("snapshottable_features_response", true, (a, ctx) -> new GetFeaturesResponse((List)a[0]));

    public GetFeaturesResponse(List<SnapshottableFeature> features) {
        this.features = features;
    }

    public List<SnapshottableFeature> getFeatures() {
        return this.features;
    }

    public static GetFeaturesResponse parse(XContentParser parser) {
        return (GetFeaturesResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFeaturesResponse)) {
            return false;
        }
        GetFeaturesResponse that = (GetFeaturesResponse)o;
        return this.getFeatures().equals(that.getFeatures());
    }

    public int hashCode() {
        return Objects.hash(this.getFeatures());
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshottableFeature::parse, FEATURES);
    }

    public static class SnapshottableFeature {
        private final String featureName;
        private final String description;
        private static final ParseField FEATURE_NAME = new ParseField("name", new String[0]);
        private static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
        private static final ConstructingObjectParser<SnapshottableFeature, Void> PARSER = new ConstructingObjectParser("feature", true, (a, ctx) -> new SnapshottableFeature((String)a[0], (String)a[1]));

        public SnapshottableFeature(String featureName, String description) {
            this.featureName = featureName;
            this.description = description;
        }

        public static SnapshottableFeature parse(XContentParser parser, Void ctx) {
            return (SnapshottableFeature)PARSER.apply(parser, (Object)ctx);
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SnapshottableFeature)) {
                return false;
            }
            SnapshottableFeature feature = (SnapshottableFeature)o;
            return Objects.equals(this.getFeatureName(), feature.getFeatureName());
        }

        public int hashCode() {
            return Objects.hash(this.getFeatureName());
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), FEATURE_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), DESCRIPTION, ObjectParser.ValueType.STRING);
        }
    }
}

