/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ShrinkAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "shrink";
    private static final ParseField NUMBER_OF_SHARDS_FIELD = new ParseField("number_of_shards", new String[0]);
    private static final ParseField MAX_PRIMARY_SHARD_SIZE = new ParseField("max_primary_shard_size", new String[0]);
    private static final ConstructingObjectParser<ShrinkAction, Void> PARSER = new ConstructingObjectParser("shrink", true, a -> new ShrinkAction((Integer)a[0], (ByteSizeValue)a[1]));
    private Integer numberOfShards;
    private ByteSizeValue maxPrimaryShardSize;

    public static ShrinkAction parse(XContentParser parser) throws IOException {
        return (ShrinkAction)PARSER.parse(parser, null);
    }

    public ShrinkAction(@Nullable Integer numberOfShards, ByteSizeValue maxPrimaryShardSize) {
        if (numberOfShards != null && maxPrimaryShardSize != null) {
            throw new IllegalArgumentException("Cannot set both [number_of_shards] and [max_primary_shard_size]");
        }
        if (numberOfShards == null && maxPrimaryShardSize == null) {
            throw new IllegalArgumentException("Either [number_of_shards] or [max_primary_shard_size] must be set");
        }
        if (maxPrimaryShardSize != null) {
            if (maxPrimaryShardSize.getBytes() <= 0L) {
                throw new IllegalArgumentException("[max_primary_shard_size] must be greater than 0");
            }
            this.maxPrimaryShardSize = maxPrimaryShardSize;
        } else {
            if (numberOfShards <= 0) {
                throw new IllegalArgumentException("[" + NUMBER_OF_SHARDS_FIELD.getPreferredName() + "] must be greater than 0");
            }
            this.numberOfShards = numberOfShards;
        }
    }

    Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfShards != null) {
            builder.field(NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.numberOfShards);
        }
        if (this.maxPrimaryShardSize != null) {
            builder.field(MAX_PRIMARY_SHARD_SIZE.getPreferredName(), (ToXContent)this.maxPrimaryShardSize);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkAction that = (ShrinkAction)o;
        return Objects.equals(this.numberOfShards, that.numberOfShards) && Objects.equals(this.maxPrimaryShardSize, that.maxPrimaryShardSize);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfShards, this.maxPrimaryShardSize);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUMBER_OF_SHARDS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_PRIMARY_SHARD_SIZE.getPreferredName()), MAX_PRIMARY_SHARD_SIZE, ObjectParser.ValueType.STRING);
    }
}

