/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.enrich;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.TaskInfo;

public final class StatsResponse {
    private static ParseField EXECUTING_POLICIES_FIELD = new ParseField("executing_policies", new String[0]);
    private static ParseField COORDINATOR_STATS_FIELD = new ParseField("coordinator_stats", new String[0]);
    private static final ConstructingObjectParser<StatsResponse, Void> PARSER = new ConstructingObjectParser("stats_response", true, args -> new StatsResponse((List)args[0], (List)args[1]));
    private final List<ExecutingPolicy> executingPolicies;
    private final List<CoordinatorStats> coordinatorStats;

    public static StatsResponse fromXContent(XContentParser parser) {
        return (StatsResponse)PARSER.apply(parser, null);
    }

    public StatsResponse(List<ExecutingPolicy> executingPolicies, List<CoordinatorStats> coordinatorStats) {
        this.executingPolicies = executingPolicies;
        this.coordinatorStats = coordinatorStats;
    }

    public List<ExecutingPolicy> getExecutingPolicies() {
        return this.executingPolicies;
    }

    public List<CoordinatorStats> getCoordinatorStats() {
        return this.coordinatorStats;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ConstructingObjectParser)ExecutingPolicy.PARSER).apply(arg_0, arg_1), EXECUTING_POLICIES_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ConstructingObjectParser)CoordinatorStats.PARSER).apply(arg_0, arg_1), COORDINATOR_STATS_FIELD);
    }

    public static class ExecutingPolicy {
        static ParseField NAME_FIELD = new ParseField("name", new String[0]);
        static ParseField TASK_FIELD = new ParseField("task", new String[0]);
        private static final ConstructingObjectParser<ExecutingPolicy, Void> PARSER = new ConstructingObjectParser("executing_policy_item", true, args -> new ExecutingPolicy((String)args[0], (TaskInfo)args[1]));
        private final String name;
        private final TaskInfo taskInfo;

        public ExecutingPolicy(String name, TaskInfo taskInfo) {
            this.name = name;
            this.taskInfo = taskInfo;
        }

        public String getName() {
            return this.name;
        }

        public TaskInfo getTaskInfo() {
            return this.taskInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutingPolicy that = (ExecutingPolicy)o;
            return this.name.equals(that.name) && this.taskInfo.equals((Object)that.taskInfo);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.taskInfo);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TaskInfo.fromXContent((XContentParser)p), TASK_FIELD);
        }
    }

    public static final class CoordinatorStats {
        static ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
        static ParseField QUEUE_SIZE_FIELD = new ParseField("queue_size", new String[0]);
        static ParseField REMOTE_REQUESTS_CONCURRENT_FIELD = new ParseField("remote_requests_current", new String[0]);
        static ParseField REMOTE_REQUESTS_TOTAL_FIELD = new ParseField("remote_requests_total", new String[0]);
        static ParseField EXECUTED_SEARCHES_FIELD = new ParseField("executed_searches_total", new String[0]);
        private static final ConstructingObjectParser<CoordinatorStats, Void> PARSER = new ConstructingObjectParser("coordinator_stats_item", true, args -> new CoordinatorStats((String)args[0], (Integer)args[1], (Integer)args[2], (Long)args[3], (Long)args[4]));
        private final String nodeId;
        private final int queueSize;
        private final int remoteRequestsCurrent;
        private final long remoteRequestsTotal;
        private final long executedSearchesTotal;

        public CoordinatorStats(String nodeId, int queueSize, int remoteRequestsCurrent, long remoteRequestsTotal, long executedSearchesTotal) {
            this.nodeId = nodeId;
            this.queueSize = queueSize;
            this.remoteRequestsCurrent = remoteRequestsCurrent;
            this.remoteRequestsTotal = remoteRequestsTotal;
            this.executedSearchesTotal = executedSearchesTotal;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getRemoteRequestsCurrent() {
            return this.remoteRequestsCurrent;
        }

        public long getRemoteRequestsTotal() {
            return this.remoteRequestsTotal;
        }

        public long getExecutedSearchesTotal() {
            return this.executedSearchesTotal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoordinatorStats stats = (CoordinatorStats)o;
            return Objects.equals(this.nodeId, stats.nodeId) && this.queueSize == stats.queueSize && this.remoteRequestsCurrent == stats.remoteRequestsCurrent && this.remoteRequestsTotal == stats.remoteRequestsTotal && this.executedSearchesTotal == stats.executedSearchesTotal;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.queueSize, this.remoteRequestsCurrent, this.remoteRequestsTotal, this.executedSearchesTotal);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), QUEUE_SIZE_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), REMOTE_REQUESTS_CONCURRENT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), REMOTE_REQUESTS_TOTAL_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXECUTED_SEARCHES_FIELD);
        }
    }
}

