/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.Regression;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class MeanSquaredLogarithmicErrorMetric
implements EvaluationMetric {
    public static final String NAME = Regression.LossFunction.MSLE.toString();
    public static final ParseField OFFSET = new ParseField("offset", new String[0]);
    private static final ConstructingObjectParser<MeanSquaredLogarithmicErrorMetric, Void> PARSER = new ConstructingObjectParser(NAME, true, args -> new MeanSquaredLogarithmicErrorMetric((Double)args[0]));
    private final Double offset;

    public static MeanSquaredLogarithmicErrorMetric fromXContent(XContentParser parser) {
        return (MeanSquaredLogarithmicErrorMetric)PARSER.apply(parser, null);
    }

    public MeanSquaredLogarithmicErrorMetric(@Nullable Double offset) {
        this.offset = offset;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.offset != null) {
            builder.field(OFFSET.getPreferredName(), this.offset);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanSquaredLogarithmicErrorMetric that = (MeanSquaredLogarithmicErrorMetric)o;
        return Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), OFFSET);
    }

    public static class Result
    implements EvaluationMetric.Result {
        public static final ParseField VALUE = new ParseField("value", new String[0]);
        private final double value;
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser(NAME + "_result", true, args -> new Result((Double)args[0]));

        public static Result fromXContent(XContentParser parser) {
            return (Result)PARSER.apply(parser, null);
        }

        public Result(double value) {
            this.value = value;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(VALUE.getPreferredName(), this.value);
            builder.endObject();
            return builder;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public String getMetricName() {
            return NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        static {
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), VALUE);
        }
    }
}

