/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.security.AuthenticateResponse;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.TimeValue;

public final class DelegatePkiAuthenticationResponse {
    private final String accessToken;
    private final String type;
    private final TimeValue expiresIn;
    private final AuthenticateResponse authentication;
    private static final ConstructingObjectParser<DelegatePkiAuthenticationResponse, Void> PARSER = new ConstructingObjectParser("delegate_pki_response", true, args -> new DelegatePkiAuthenticationResponse((String)args[0], (String)args[1], TimeValue.timeValueSeconds((long)((Long)args[2])), (AuthenticateResponse)args[3]));

    public DelegatePkiAuthenticationResponse(String accessToken, String type, TimeValue expiresIn, AuthenticateResponse authentication) {
        this.accessToken = accessToken;
        this.type = type;
        this.expiresIn = expiresIn;
        this.authentication = authentication;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getType() {
        return this.type;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public AuthenticateResponse getAuthentication() {
        return this.authentication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatePkiAuthenticationResponse that = (DelegatePkiAuthenticationResponse)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.type, that.type) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.type, this.expiresIn, this.authentication);
    }

    public static DelegatePkiAuthenticationResponse fromXContent(XContentParser parser) throws IOException {
        return (DelegatePkiAuthenticationResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("access_token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("expires_in", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> AuthenticateResponse.fromXContent(p), new ParseField("authentication", new String[0]));
    }
}

