/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.graph;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class Vertex
implements ToXContentFragment {
    private final String field;
    private final String term;
    private double weight;
    private final int depth;
    private final long bg;
    private long fg;
    private static final ParseField FIELD = new ParseField("field", new String[0]);
    private static final ParseField TERM = new ParseField("term", new String[0]);
    private static final ParseField WEIGHT = new ParseField("weight", new String[0]);
    private static final ParseField DEPTH = new ParseField("depth", new String[0]);
    private static final ParseField FG = new ParseField("fg", new String[0]);
    private static final ParseField BG = new ParseField("bg", new String[0]);
    private static final ConstructingObjectParser<Vertex, Void> PARSER = new ConstructingObjectParser("VertexParser", true, args -> {
        String field = (String)args[0];
        String term = (String)args[1];
        double weight = (Double)args[2];
        int depth = (Integer)args[3];
        Long optionalBg = (Long)args[4];
        Long optionalFg = (Long)args[5];
        long bg = optionalBg == null ? 0L : optionalBg;
        long fg = optionalFg == null ? 0L : optionalFg;
        return new Vertex(field, term, weight, depth, bg, fg);
    });

    public Vertex(String field, String term, double weight, int depth, long bg, long fg) {
        this.field = field;
        this.term = term;
        this.weight = weight;
        this.depth = depth;
        this.bg = bg;
        this.fg = fg;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.term, this.weight, this.depth, this.bg, this.fg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return this.depth == other.depth && this.weight == other.weight && this.bg == other.bg && this.fg == other.fg && Objects.equals(this.field, other.field) && Objects.equals(this.term, other.term);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean returnDetailedInfo = params.paramAsBoolean("returnDetailedInfo", false);
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(TERM.getPreferredName(), this.term);
        builder.field(WEIGHT.getPreferredName(), this.weight);
        builder.field(DEPTH.getPreferredName(), this.depth);
        if (returnDetailedInfo) {
            builder.field(FG.getPreferredName(), this.fg);
            builder.field(BG.getPreferredName(), this.bg);
        }
        return builder;
    }

    static Vertex fromXContent(XContentParser parser) throws IOException {
        return (Vertex)PARSER.apply(parser, null);
    }

    public VertexId getId() {
        return Vertex.createId(this.field, this.term);
    }

    public static VertexId createId(String field, String term) {
        return new VertexId(field, term);
    }

    public String toString() {
        return this.getId().toString();
    }

    public String getField() {
        return this.field;
    }

    public String getTerm() {
        return this.term;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public long getBg() {
        return this.bg;
    }

    public long getFg() {
        return this.fg;
    }

    public void setFg(long fg) {
        this.fg = fg;
    }

    public int getHopDepth() {
        return this.depth;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TERM);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), WEIGHT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), DEPTH);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), BG);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), FG);
    }

    public static class VertexId {
        private final String field;
        private final String term;

        public VertexId(String field, String term) {
            this.field = field;
            this.term = term;
        }

        public String getField() {
            return this.field;
        }

        public String getTerm() {
            return this.term;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexId vertexId = (VertexId)o;
            if (this.field != null ? !this.field.equals(vertexId.field) : vertexId.field != null) {
                return false;
            }
            return !(this.term != null ? !this.term.equals(vertexId.term) : vertexId.term != null);
        }

        public int hashCode() {
            int result = this.field != null ? this.field.hashCode() : 0;
            result = 31 * result + (this.term != null ? this.term.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.field + ":" + this.term;
        }
    }
}

