/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.client.Validatable;

public final class ClearServiceAccountTokenCacheRequest
implements Validatable {
    private final String namespace;
    private final String serviceName;
    private final String[] tokenNames;

    public ClearServiceAccountTokenCacheRequest(String namespace, String serviceName, String ... tokenNames) {
        this.namespace = Objects.requireNonNull(namespace, "namespace is required");
        this.serviceName = Objects.requireNonNull(serviceName, "service-name is required");
        this.tokenNames = tokenNames;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String[] getTokenNames() {
        return this.tokenNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearServiceAccountTokenCacheRequest that = (ClearServiceAccountTokenCacheRequest)o;
        return this.namespace.equals(that.namespace) && this.serviceName.equals(that.serviceName) && Arrays.equals(this.tokenNames, that.tokenNames);
    }

    public int hashCode() {
        int result = Objects.hash(this.namespace, this.serviceName);
        result = 31 * result + Arrays.hashCode(this.tokenNames);
        return result;
    }
}

