/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.client.security.ServiceAccountCredentialsNodesResponse;
import org.elasticsearch.client.security.support.ServiceTokenInfo;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.List;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class GetServiceAccountCredentialsResponse {
    private final String principal;
    private final java.util.List<ServiceTokenInfo> indexTokenInfos;
    private final ServiceAccountCredentialsNodesResponse nodesResponse;
    static ConstructingObjectParser<GetServiceAccountCredentialsResponse, Void> PARSER = new ConstructingObjectParser("get_service_account_credentials_response", args -> {
        int count = (Integer)args[1];
        java.util.List indexTokenInfos = (java.util.List)args[2];
        ServiceAccountCredentialsNodesResponse fileTokensResponse = (ServiceAccountCredentialsNodesResponse)args[3];
        if (count != indexTokenInfos.size() + fileTokensResponse.getFileTokenInfos().size()) {
            throw new IllegalArgumentException("number of tokens do not match");
        }
        return new GetServiceAccountCredentialsResponse((String)args[0], indexTokenInfos, fileTokensResponse);
    });

    public GetServiceAccountCredentialsResponse(String principal, java.util.List<ServiceTokenInfo> indexTokenInfos, ServiceAccountCredentialsNodesResponse nodesResponse) {
        this.principal = Objects.requireNonNull(principal, "principal is required");
        this.indexTokenInfos = List.copyOf((Collection)Objects.requireNonNull(indexTokenInfos, "service token infos are required"));
        this.nodesResponse = Objects.requireNonNull(nodesResponse, "nodes response is required");
    }

    public String getPrincipal() {
        return this.principal;
    }

    public java.util.List<ServiceTokenInfo> getIndexTokenInfos() {
        return this.indexTokenInfos;
    }

    public ServiceAccountCredentialsNodesResponse getNodesResponse() {
        return this.nodesResponse;
    }

    public static GetServiceAccountCredentialsResponse fromXContent(XContentParser parser) throws IOException {
        return (GetServiceAccountCredentialsResponse)PARSER.parse(parser, null);
    }

    static java.util.List<ServiceTokenInfo> parseIndexTokenInfos(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        ArrayList<ServiceTokenInfo> indexTokenInfos = new ArrayList<ServiceTokenInfo>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            indexTokenInfos.add(new ServiceTokenInfo(parser.currentName(), "index"));
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        }
        return indexTokenInfos;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("service_account", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("count", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> GetServiceAccountCredentialsResponse.parseIndexTokenInfos(p), new ParseField("tokens", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ServiceAccountCredentialsNodesResponse.fromXContent(p), new ParseField("nodes_credentials", new String[0]));
    }
}

