/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.analytics;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TopMetricsAggregationBuilder
extends AbstractAggregationBuilder<TopMetricsAggregationBuilder> {
    public static final String NAME = "top_metrics";
    private final SortBuilder<?> sort;
    private final int size;
    private final List<String> metrics;

    public TopMetricsAggregationBuilder(String name, SortBuilder<?> sort, int size, String ... metrics) {
        super(name);
        this.sort = sort;
        this.size = size;
        this.metrics = Arrays.asList(metrics);
    }

    public String getType() {
        return NAME;
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("sort");
        this.sort.toXContent(builder, params);
        builder.endArray();
        builder.field("size", this.size);
        builder.startArray("metrics");
        for (String metric : this.metrics) {
            builder.startObject().field("field", metric).endObject();
        }
        builder.endArray();
        return builder.endObject();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        throw new UnsupportedOperationException();
    }
}

