/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicyMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GetLifecyclePolicyResponse
implements ToXContentObject {
    private final ImmutableOpenMap<String, LifecyclePolicyMetadata> policies;

    public GetLifecyclePolicyResponse(ImmutableOpenMap<String, LifecyclePolicyMetadata> policies) {
        this.policies = policies;
    }

    public ImmutableOpenMap<String, LifecyclePolicyMetadata> getPolicies() {
        return this.policies;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ObjectObjectCursor stringLifecyclePolicyObjectObjectCursor : this.policies) {
            builder.field((String)stringLifecyclePolicyObjectObjectCursor.key, (ToXContent)stringLifecyclePolicyObjectObjectCursor.value);
        }
        builder.endObject();
        return builder;
    }

    public static GetLifecyclePolicyResponse fromXContent(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder policies = ImmutableOpenMap.builder();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String policyName = parser.currentName();
                LifecyclePolicyMetadata policyDefinion = LifecyclePolicyMetadata.parse(parser, policyName);
                policies.put((Object)policyName, (Object)policyDefinion);
                continue;
            }
            parser.nextToken();
        }
        return new GetLifecyclePolicyResponse((ImmutableOpenMap<String, LifecyclePolicyMetadata>)policies.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetLifecyclePolicyResponse that = (GetLifecyclePolicyResponse)o;
        return Objects.equals(this.getPolicies(), that.getPolicies());
    }

    public int hashCode() {
        return Objects.hash(this.getPolicies());
    }
}

