/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.ensemble.OutputAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class WeightedMode
implements OutputAggregator {
    public static final String NAME = "weighted_mode";
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    public static final ParseField NUM_CLASSES = new ParseField("num_classes", new String[0]);
    private static final ConstructingObjectParser<WeightedMode, Void> PARSER = new ConstructingObjectParser("weighted_mode", true, a -> new WeightedMode((Integer)a[0], (List)a[1]));
    private final List<Double> weights;
    private final int numClasses;

    public static WeightedMode fromXContent(XContentParser parser) {
        return (WeightedMode)PARSER.apply(parser, null);
    }

    public WeightedMode(int numClasses, List<Double> weights) {
        this.weights = weights;
        this.numClasses = numClasses;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), this.weights);
        }
        builder.field(NUM_CLASSES.getPreferredName(), this.numClasses);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedMode that = (WeightedMode)o;
        return Objects.equals(this.weights, that.weights) && this.numClasses == that.numClasses;
    }

    public int hashCode() {
        return Objects.hash(this.weights, this.numClasses);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_CLASSES);
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
    }
}

