/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RegressionConfig
implements InferenceConfig {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    private static final ConstructingObjectParser<RegressionConfig, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, args -> new RegressionConfig((String)args[0], (Integer)args[1]));
    private final String resultsField;
    private final Integer numTopFeatureImportanceValues;

    public static RegressionConfig fromXContent(XContentParser parser) {
        return (RegressionConfig)PARSER.apply(parser, null);
    }

    public RegressionConfig() {
        this(null, null);
    }

    public RegressionConfig(String resultsField, Integer numTopFeatureImportanceValues) {
        this.resultsField = resultsField;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegressionConfig that = (RegressionConfig)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField, this.numTopFeatureImportanceValues);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
    }
}

