/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelDefinition
implements ToXContentObject {
    public static final String NAME = "trained_model_doc";
    public static final ParseField TRAINED_MODEL = new ParseField("trained_model", new String[0]);
    public static final ParseField PREPROCESSORS = new ParseField("preprocessors", new String[0]);
    public static final ParseField INPUT = new ParseField("input", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("trained_model_doc", true, Builder::new);
    private final TrainedModel trainedModel;
    private final List<PreProcessor> preProcessors;
    private final Input input;

    public static Builder fromXContent(XContentParser parser) throws IOException {
        return (Builder)PARSER.parse(parser, null);
    }

    TrainedModelDefinition(TrainedModel trainedModel, List<PreProcessor> preProcessors, Input input) {
        this.trainedModel = trainedModel;
        this.preProcessors = preProcessors == null ? Collections.emptyList() : Collections.unmodifiableList(preProcessors);
        this.input = input;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, false, TRAINED_MODEL.getPreferredName(), Collections.singletonList(this.trainedModel));
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PREPROCESSORS.getPreferredName(), this.preProcessors);
        if (this.input != null) {
            builder.field(INPUT.getPreferredName(), (ToXContent)this.input);
        }
        builder.endObject();
        return builder;
    }

    public TrainedModel getTrainedModel() {
        return this.trainedModel;
    }

    public List<PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public Input getInput() {
        return this.input;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinition that = (TrainedModelDefinition)o;
        return Objects.equals(this.trainedModel, that.trainedModel) && Objects.equals(this.preProcessors, that.preProcessors) && Objects.equals(this.input, that.input);
    }

    public int hashCode() {
        return Objects.hash(this.trainedModel, this.preProcessors, this.input);
    }

    static {
        PARSER.declareNamedObjects((rec$, x$0) -> ((Builder)rec$).setTrainedModel(x$0), (p, c, n) -> (TrainedModel)p.namedObject(TrainedModel.class, n, null), modelDocBuilder -> {}, TRAINED_MODEL);
        PARSER.declareNamedObjects(Builder::setPreProcessors, (p, c, n) -> (PreProcessor)p.namedObject(PreProcessor.class, n, null), trainedModelDefBuilder -> {}, PREPROCESSORS);
        PARSER.declareObject(Builder::setInput, (p, c) -> Input.fromXContent(p), INPUT);
    }

    public static class Input
    implements ToXContentObject {
        public static final String NAME = "trained_mode_definition_input";
        public static final ParseField FIELD_NAMES = new ParseField("field_names", new String[0]);
        public static final ConstructingObjectParser<Input, Void> PARSER = new ConstructingObjectParser("trained_mode_definition_input", true, a -> new Input((List)a[0]));
        private final List<String> fieldNames;

        public static Input fromXContent(XContentParser parser) throws IOException {
            return (Input)PARSER.parse(parser, null);
        }

        public Input(List<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.fieldNames != null) {
                builder.field(FIELD_NAMES.getPreferredName(), this.fieldNames);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input that = (Input)o;
            return Objects.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            return Objects.hash(this.fieldNames);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), FIELD_NAMES);
        }
    }

    public static class Builder {
        private List<PreProcessor> preProcessors;
        private TrainedModel trainedModel;
        private Input input;

        public Builder setPreProcessors(List<PreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder setTrainedModel(TrainedModel trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        public Builder setInput(Input input) {
            this.input = input;
            return this;
        }

        private Builder setTrainedModel(List<TrainedModel> trainedModel) {
            assert (trainedModel.size() == 1);
            return this.setTrainedModel(trainedModel.get(0));
        }

        public TrainedModelDefinition build() {
            return new TrainedModelDefinition(this.trainedModel, this.preProcessors, this.input);
        }
    }
}

