/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.elasticsearch.client.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.client.ml.inference.trainedmodel.ensemble.OutputAggregator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class Ensemble
implements TrainedModel {
    public static final String NAME = "ensemble";
    public static final ParseField FEATURE_NAMES = new ParseField("feature_names", new String[0]);
    public static final ParseField TRAINED_MODELS = new ParseField("trained_models", new String[0]);
    public static final ParseField AGGREGATE_OUTPUT = new ParseField("aggregate_output", new String[0]);
    public static final ParseField TARGET_TYPE = new ParseField("target_type", new String[0]);
    public static final ParseField CLASSIFICATION_LABELS = new ParseField("classification_labels", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("ensemble", true, Builder::new);
    private final List<String> featureNames;
    private final List<TrainedModel> models;
    private final OutputAggregator outputAggregator;
    private final TargetType targetType;
    private final List<String> classificationLabels;

    public static Ensemble fromXContent(XContentParser parser) {
        return ((Builder)PARSER.apply(parser, null)).build();
    }

    Ensemble(List<String> featureNames, List<TrainedModel> models, @Nullable OutputAggregator outputAggregator, TargetType targetType, @Nullable List<String> classificationLabels) {
        this.featureNames = featureNames;
        this.models = models;
        this.outputAggregator = outputAggregator;
        this.targetType = targetType;
        this.classificationLabels = classificationLabels;
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.featureNames != null) {
            builder.field(FEATURE_NAMES.getPreferredName(), this.featureNames);
        }
        if (this.models != null) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, true, TRAINED_MODELS.getPreferredName(), this.models);
        }
        if (this.outputAggregator != null) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, false, AGGREGATE_OUTPUT.getPreferredName(), Collections.singletonList(this.outputAggregator));
        }
        if (this.targetType != null) {
            builder.field(TARGET_TYPE.getPreferredName(), (Object)this.targetType);
        }
        if (this.classificationLabels != null) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ensemble that = (Ensemble)o;
        return Objects.equals(this.featureNames, that.featureNames) && Objects.equals(this.models, that.models) && Objects.equals((Object)this.targetType, (Object)that.targetType) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.outputAggregator, that.outputAggregator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureNames, this.models, this.outputAggregator, this.classificationLabels, this.targetType});
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(Builder::setFeatureNames, FEATURE_NAMES);
        PARSER.declareNamedObjects(Builder::setTrainedModels, (p, c, n) -> (TrainedModel)p.namedObject(TrainedModel.class, n, null), ensembleBuilder -> {}, TRAINED_MODELS);
        PARSER.declareNamedObjects((rec$, x$0) -> ((Builder)rec$).setOutputAggregatorFromParser(x$0), (p, c, n) -> (OutputAggregator)p.namedObject(OutputAggregator.class, n, null), ensembleBuilder -> {}, AGGREGATE_OUTPUT);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setTargetType(x$0), TARGET_TYPE);
        PARSER.declareStringArray(Builder::setClassificationLabels, CLASSIFICATION_LABELS);
    }

    public static class Builder {
        private List<String> featureNames;
        private List<TrainedModel> trainedModels;
        private OutputAggregator outputAggregator;
        private TargetType targetType;
        private List<String> classificationLabels;

        public Builder setFeatureNames(List<String> featureNames) {
            this.featureNames = featureNames;
            return this;
        }

        public Builder setTrainedModels(List<TrainedModel> trainedModels) {
            this.trainedModels = trainedModels;
            return this;
        }

        public Builder setOutputAggregator(OutputAggregator outputAggregator) {
            this.outputAggregator = outputAggregator;
            return this;
        }

        public Builder setTargetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        private void setOutputAggregatorFromParser(List<OutputAggregator> outputAggregators) {
            this.setOutputAggregator(outputAggregators.get(0));
        }

        private void setTargetType(String targetType) {
            this.targetType = TargetType.fromString(targetType);
        }

        public Ensemble build() {
            return new Ensemble(this.featureNames, this.trainedModels, this.outputAggregator, this.targetType, this.classificationLabels);
        }
    }
}

