/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.ml.dataframe.QueryConfig;
import org.elasticsearch.client.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class EvaluateDataFrameRequest
implements ToXContentObject,
Validatable {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    private static final ParseField EVALUATION = new ParseField("evaluation", new String[0]);
    private static final ConstructingObjectParser<EvaluateDataFrameRequest, Void> PARSER = new ConstructingObjectParser("evaluate_data_frame_request", true, args -> new EvaluateDataFrameRequest((List)args[0], (QueryConfig)args[1], (Evaluation)args[2]));
    private List<String> indices;
    private QueryConfig queryConfig;
    private Evaluation evaluation;

    private static Evaluation parseEvaluation(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        Evaluation evaluation = (Evaluation)parser.namedObject(Evaluation.class, parser.currentName(), null);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        return evaluation;
    }

    public static EvaluateDataFrameRequest fromXContent(XContentParser parser) {
        return (EvaluateDataFrameRequest)PARSER.apply(parser, null);
    }

    public EvaluateDataFrameRequest(String index, @Nullable QueryConfig queryConfig, Evaluation evaluation) {
        this(Arrays.asList(index), queryConfig, evaluation);
    }

    public EvaluateDataFrameRequest(List<String> indices, @Nullable QueryConfig queryConfig, Evaluation evaluation) {
        this.setIndices(indices);
        this.setQueryConfig(queryConfig);
        this.setEvaluation(evaluation);
    }

    public List<String> getIndices() {
        return Collections.unmodifiableList(this.indices);
    }

    public final void setIndices(List<String> indices) {
        Objects.requireNonNull(indices);
        this.indices = new ArrayList<String>(indices);
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public final void setQueryConfig(QueryConfig queryConfig) {
        this.queryConfig = queryConfig;
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    public final void setEvaluation(Evaluation evaluation) {
        this.evaluation = evaluation;
    }

    @Override
    public Optional<ValidationException> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.indices.isEmpty()) {
            errors.add("At least one index must be specified");
        }
        if (this.evaluation == null) {
            errors.add("evaluation must not be null");
        }
        return errors.isEmpty() ? Optional.empty() : Optional.of(ValidationException.withErrors(errors));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDEX.getPreferredName(), this.indices.toArray());
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), (ToXContent)this.queryConfig.getQuery());
        }
        builder.startObject(EVALUATION.getPreferredName()).field(this.evaluation.getName(), (ToXContent)this.evaluation).endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.queryConfig, this.evaluation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluateDataFrameRequest that = (EvaluateDataFrameRequest)o;
        return Objects.equals(this.indices, that.indices) && Objects.equals(this.queryConfig, that.queryConfig) && Objects.equals(this.evaluation, that.evaluation);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryConfig.fromXContent(p), QUERY);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> EvaluateDataFrameRequest.parseEvaluation(p), EVALUATION);
    }
}

