/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.mr.security.TokenUtil;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.util.ClusterInfo;

public final class EsMapReduceUtil {
    private static final Log LOG = LogFactory.getLog(EsMapReduceUtil.class);

    private EsMapReduceUtil() {
    }

    public static void initCredentials(Job job) {
        Configuration configuration = job.getConfiguration();
        Settings settings = HadoopSettingsManager.loadFrom(configuration);
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LOG);
        UserProvider userProvider = UserProvider.create(settings);
        if (userProvider.isEsKerberosEnabled()) {
            User user = userProvider.getUser();
            ClusterInfo clusterInfo = settings.getClusterInfoOrNull();
            RestClient bootstrap = new RestClient(settings);
            try {
                if (clusterInfo == null) {
                    clusterInfo = bootstrap.mainInfo();
                }
                TokenUtil.addTokenForJob(bootstrap, clusterInfo.getClusterName(), user, job);
            }
            catch (EsHadoopException ex) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot detect ES version - typically this happens if the network/Elasticsearch cluster is not accessible or when targeting a WAN/Cloud instance without the proper setting '%s'", "es.nodes.wan.only"), ex);
            }
            finally {
                bootstrap.close();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ignoring Elasticsearch credentials since Kerberos Auth is not enabled.");
        }
    }

    public static void initCredentials(JobConf jobConf) {
        Settings settings = HadoopSettingsManager.loadFrom(jobConf);
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LOG);
        UserProvider userProvider = UserProvider.create(settings);
        if (userProvider.isEsKerberosEnabled()) {
            User user = userProvider.getUser();
            ClusterInfo clusterInfo = settings.getClusterInfoOrNull();
            RestClient bootstrap = new RestClient(settings);
            try {
                if (clusterInfo == null) {
                    clusterInfo = bootstrap.mainInfo();
                }
                TokenUtil.addTokenForJobConf(bootstrap, clusterInfo.getClusterName(), user, jobConf);
            }
            catch (EsHadoopException ex) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot detect ES version - typically this happens if the network/Elasticsearch cluster is not accessible or when targeting a WAN/Cloud instance without the proper setting '%s'", "es.nodes.wan.only"), ex);
            }
            finally {
                bootstrap.close();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ignoring Elasticsearch credentials since Kerberos Auth is not enabled.");
        }
    }
}

