/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.handler.read.impl;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.handler.ErrorHandler;
import org.elasticsearch.hadoop.handler.impl.AbortOnFailure;
import org.elasticsearch.hadoop.handler.impl.AbstractHandlerLoader;
import org.elasticsearch.hadoop.handler.impl.DropAndLog;
import org.elasticsearch.hadoop.handler.impl.elasticsearch.ElasticsearchHandler;
import org.elasticsearch.hadoop.serialization.handler.read.IDeserializationErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.read.impl.DelegatingErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.read.impl.DeserializationEventConverter;
import org.elasticsearch.hadoop.serialization.handler.read.impl.DeserializationLogRenderer;

public class DeserializationHandlerLoader
extends AbstractHandlerLoader<IDeserializationErrorHandler> {
    public static final String ES_READ_DATA_ERROR_HANDLERS = "es.read.data.error.handlers";
    public static final String ES_READ_DATA_ERROR_HANDLER = "es.read.data.error.handler";

    public DeserializationHandlerLoader() {
        super(IDeserializationErrorHandler.class);
    }

    @Override
    protected String getHandlersPropertyName() {
        return ES_READ_DATA_ERROR_HANDLERS;
    }

    @Override
    protected String getHandlerPropertyName() {
        return ES_READ_DATA_ERROR_HANDLER;
    }

    @Override
    protected IDeserializationErrorHandler loadBuiltInHandler(AbstractHandlerLoader.NamedHandlers handlerName) {
        ErrorHandler genericHandler;
        switch (handlerName) {
            case FAIL: {
                genericHandler = AbortOnFailure.create();
                break;
            }
            case LOG: {
                genericHandler = DropAndLog.create(new DeserializationLogRenderer());
                break;
            }
            case ES: {
                genericHandler = ElasticsearchHandler.create(this.getSettings(), new DeserializationEventConverter());
                break;
            }
            default: {
                throw new EsHadoopIllegalArgumentException("Could not find default implementation for built in handler type [" + (Object)((Object)handlerName) + "]");
            }
        }
        return new DelegatingErrorHandler(genericHandler);
    }
}

