/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.HttpStatus;
import org.elasticsearch.hadoop.rest.Retry;
import org.elasticsearch.hadoop.serialization.SettingsAware;

public class SimpleHttpRetryPolicy
implements HttpRetryPolicy,
SettingsAware {
    @Override
    public Retry init() {
        return new SimpleRetry();
    }

    @Override
    public void setSettings(Settings settings) {
    }

    private class SimpleRetry
    implements Retry {
        private SimpleRetry() {
        }

        @Override
        public boolean retry(int httpStatus) {
            if (HttpStatus.isSuccess(httpStatus)) {
                return false;
            }
            switch (httpStatus) {
                case 429: 
                case 503: {
                    return true;
                }
            }
            return false;
        }
    }
}

