/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.DelegatingInputStream;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.EsHadoopTransportException;
import org.elasticsearch.hadoop.rest.HeaderProcessor;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.ReusableInputStream;
import org.elasticsearch.hadoop.rest.SimpleResponse;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.commonshttp.BytesArrayRequestEntity;
import org.elasticsearch.hadoop.rest.commonshttp.DelegatedProtocol;
import org.elasticsearch.hadoop.rest.commonshttp.DeleteMethodWithBody;
import org.elasticsearch.hadoop.rest.commonshttp.GetMethodWithBody;
import org.elasticsearch.hadoop.rest.commonshttp.SSLSocketFactory;
import org.elasticsearch.hadoop.rest.commonshttp.SocksSocketFactory;
import org.elasticsearch.hadoop.rest.commonshttp.auth.EsHadoopAuthPolicies;
import org.elasticsearch.hadoop.rest.commonshttp.auth.bearer.EsApiKeyAuthScheme;
import org.elasticsearch.hadoop.rest.commonshttp.auth.bearer.EsApiKeyCredentials;
import org.elasticsearch.hadoop.rest.commonshttp.auth.spnego.SpnegoAuthScheme;
import org.elasticsearch.hadoop.rest.commonshttp.auth.spnego.SpnegoCredentials;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.security.SecureSettings;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HostConfiguration;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpClient;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpConnection;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpConnectionManager;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethodBase;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpState;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpStatus;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.URI;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.URIException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.UsernamePasswordCredentials;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthChallengeParser;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthScheme;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthScope;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthState;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.methods.GetMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.methods.HeadMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.methods.PostMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.methods.PutMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.params.HttpClientParams;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.protocol.Protocol;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.ReflectionUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.encoding.HttpEncodingTools;

public class CommonsHttpTransport
implements Transport,
StatsAware {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static Log log = LogFactory.getLog(CommonsHttpTransport.class);
    private static final Method GET_SOCKET = ReflectionUtils.findMethod(HttpConnection.class, "getSocket", null);
    private final HttpClient client;
    private final HeaderProcessor headers;
    protected Stats stats = new Stats();
    private HttpConnection conn;
    private String proxyInfo = "";
    private final String httpInfo;
    private final boolean sslEnabled;
    private final String pathPrefix;
    private final Settings settings;
    private final SecureSettings secureSettings;
    private final String clusterName;
    private final UserProvider userProvider;
    private UserProvider proxyUserProvider = null;
    private String runAsUser = null;
    private boolean isProxied = false;
    private boolean isSecure = false;

    public CommonsHttpTransport(Settings settings, String host) {
        this(settings, new SecureSettings(settings), host);
    }

    public CommonsHttpTransport(Settings settings, SecureSettings secureSettings, String host) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new CommonsHttpTransport");
        }
        this.settings = settings;
        this.secureSettings = secureSettings;
        this.clusterName = settings.getClusterInfoOrUnnamedLatest().getClusterName().getName();
        this.userProvider = StringUtils.hasText(settings.getSecurityUserProviderClass()) ? UserProvider.create(settings) : null;
        this.httpInfo = host;
        this.sslEnabled = settings.getNetworkSSLEnabled();
        String pathPref = settings.getNodesPathPrefix();
        this.pathPrefix = StringUtils.hasText(pathPref) ? CommonsHttpTransport.addLeadingSlashIfNeeded(StringUtils.trimWhitespace(pathPref)) : StringUtils.trimWhitespace(pathPref);
        HttpClientParams params2 = new HttpClientParams();
        params2.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(settings.getHttpRetries(), false){

            @Override
            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                if (super.retryMethod(method, exception, executionCount)) {
                    ++CommonsHttpTransport.this.stats.netRetries;
                    return true;
                }
                return false;
            }
        });
        params2.setConnectionManagerTimeout(settings.getHttpTimeout());
        params2.setSoTimeout((int)settings.getHttpTimeout());
        params2.setCredentialCharset(StringUtils.UTF_8.name());
        params2.setContentCharset(StringUtils.UTF_8.name());
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig = this.setupSSLIfNeeded(settings, secureSettings, hostConfig);
        hostConfig = this.setupSocksProxy(settings, secureSettings, hostConfig);
        Object[] authSettings = this.setupHttpOrHttpsProxy(settings, secureSettings, hostConfig);
        hostConfig = (HostConfiguration)authSettings[0];
        try {
            hostConfig.setHost(new URI(CommonsHttpTransport.escapeUri(host, this.sslEnabled), false));
        }
        catch (IOException ex) {
            throw new EsHadoopTransportException("Invalid target URI " + host, ex);
        }
        this.client = new HttpClient(params2, new SocketTrackingConnectionManager());
        this.client.setHostConfiguration(hostConfig);
        this.addHttpAuth(settings, secureSettings, authSettings);
        this.completeAuth(authSettings);
        HttpConnectionManagerParams connectionParams = this.client.getHttpConnectionManager().getParams();
        connectionParams.setTcpNoDelay(true);
        connectionParams.setConnectionTimeout((int)settings.getHttpTimeout());
        this.headers = new HeaderProcessor(settings);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Opening HTTP transport to " + this.httpInfo));
        }
    }

    private HostConfiguration setupSSLIfNeeded(Settings settings, SecureSettings secureSettings, HostConfiguration hostConfig) {
        if (!this.sslEnabled) {
            return hostConfig;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SSL Connection enabled");
        }
        this.isSecure = true;
        String schema2 = "https";
        int port = 443;
        SSLSocketFactory sslFactory = new SSLSocketFactory(settings, secureSettings);
        CommonsHttpTransport.replaceProtocol(sslFactory, schema2, port);
        return hostConfig;
    }

    private void addHttpAuth(Settings settings, SecureSettings secureSettings, Object[] authSettings) {
        ArrayList<String> authPrefs = new ArrayList<String>();
        if (StringUtils.hasText(settings.getNetworkHttpAuthUser())) {
            HttpState state = authSettings[1] != null ? (HttpState)authSettings[1] : new HttpState();
            authSettings[1] = state;
            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic");
            UsernamePasswordCredentials usernamePassword = new UsernamePasswordCredentials(settings.getNetworkHttpAuthUser(), secureSettings.getSecureProperty("es.net.http.auth.pass"));
            state.setCredentials(scope, usernamePassword);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using detected HTTP Auth credentials...");
            }
            authPrefs.add("Basic");
            this.client.getParams().setAuthenticationPreemptive(true);
        }
        if (this.userProvider != null) {
            User user = this.userProvider.getUser();
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking for token using cluster name [" + this.clusterName + "]"));
            }
            if (user.getEsToken(this.clusterName) != null) {
                HttpState state = authSettings[1] != null ? (HttpState)authSettings[1] : new HttpState();
                authSettings[1] = state;
                AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "ApiKey");
                EsApiKeyCredentials tokenCredentials = new EsApiKeyCredentials(this.userProvider, this.clusterName);
                state.setCredentials(scope, tokenCredentials);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using detected Token credentials...");
                }
                EsHadoopAuthPolicies.registerAuthSchemes();
                authPrefs.add("ApiKey");
            } else if (this.userProvider.isEsKerberosEnabled()) {
                UserProvider credentialUserProvider;
                if (!StringUtils.hasText(settings.getNetworkSpnegoAuthElasticsearchPrincipal())) {
                    throw new EsHadoopIllegalArgumentException("Missing Elasticsearch Kerberos Principal name. Specify one with [es.net.spnego.auth.elasticsearch.principal]");
                }
                if (user.isProxyUser()) {
                    this.proxyUserProvider = user.getRealUserProvider();
                    this.runAsUser = user.getUserName();
                    User realUser = this.proxyUserProvider.getUser();
                    KerberosPrincipal realPrincipal = realUser.getKerberosPrincipal();
                    if (realPrincipal == null) {
                        throw new EsHadoopIllegalArgumentException("Could not locate Kerberos Principal on real user [" + realUser.getUserName() + "] underneath proxy user [" + this.runAsUser + "]");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using detected SPNEGO credentials for real user [" + realUser.getUserName() + "] to proxy as [" + this.runAsUser + "]..."));
                    }
                    credentialUserProvider = this.proxyUserProvider;
                } else if (user.getKerberosPrincipal() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using detected SPNEGO credentials for user [" + user.getUserName() + "]..."));
                    }
                    credentialUserProvider = this.userProvider;
                } else {
                    throw new EsHadoopIllegalArgumentException("Could not locate Kerberos Principal on currently logged in user.");
                }
                HttpState state = authSettings[1] != null ? (HttpState)authSettings[1] : new HttpState();
                authSettings[1] = state;
                AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate");
                SpnegoCredentials credential = new SpnegoCredentials(credentialUserProvider, settings.getNetworkSpnegoAuthElasticsearchPrincipal());
                state.setCredentials(scope, credential);
                EsHadoopAuthPolicies.registerAuthSchemes();
                authPrefs.add("Negotiate");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No UserProvider configured. Skipping Kerberos/Token auth settings");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using auth prefs: [" + authPrefs + "]"));
        }
        this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
    }

    private void completeAuth(Object[] authSettings) {
        if (authSettings[1] != null) {
            this.client.setState((HttpState)authSettings[1]);
        }
    }

    private Object[] setupHttpOrHttpsProxy(Settings settings, SecureSettings secureSettings, HostConfiguration hostConfig) {
        Object[] results = new Object[2];
        results[0] = hostConfig;
        String proxyHost = null;
        int proxyPort = -1;
        if (this.sslEnabled) {
            if (settings.getNetworkHttpsUseSystemProperties()) {
                proxyHost = System.getProperty("https.proxyHost");
                proxyPort = Integer.getInteger("https.proxyPort", -1);
            }
            if (StringUtils.hasText(settings.getNetworkProxyHttpsHost())) {
                proxyHost = settings.getNetworkProxyHttpsHost();
            }
            if (settings.getNetworkProxyHttpsPort() > 0) {
                proxyPort = settings.getNetworkProxyHttpsPort();
            }
        } else {
            if (settings.getNetworkHttpUseSystemProperties()) {
                proxyHost = System.getProperty("http.proxyHost");
                proxyPort = Integer.getInteger("http.proxyPort", -1);
            }
            if (StringUtils.hasText(settings.getNetworkProxyHttpHost())) {
                proxyHost = settings.getNetworkProxyHttpHost();
            }
            if (settings.getNetworkProxyHttpPort() > 0) {
                proxyPort = settings.getNetworkProxyHttpPort();
            }
        }
        if (StringUtils.hasText(proxyHost)) {
            hostConfig.setProxy(proxyHost, proxyPort);
            this.isProxied = true;
            this.proxyInfo = this.proxyInfo.concat(String.format(Locale.ROOT, "[%s proxy %s:%s]", this.sslEnabled ? "HTTPS" : "HTTP", proxyHost, proxyPort));
            if (this.sslEnabled) {
                if (StringUtils.hasText(settings.getNetworkProxyHttpsUser())) {
                    if (!StringUtils.hasText(secureSettings.getSecureProperty("es.net.proxy.https.pass"))) {
                        log.warn((Object)String.format("HTTPS proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.https.pass"));
                    }
                    HttpState state = new HttpState();
                    state.setProxyCredentials(AuthScope.ANY, new UsernamePasswordCredentials(settings.getNetworkProxyHttpsUser(), secureSettings.getSecureProperty("es.net.proxy.https.pass")));
                    results[1] = state;
                }
                if (log.isDebugEnabled()) {
                    if (StringUtils.hasText(settings.getNetworkProxyHttpsUser())) {
                        log.debug((Object)String.format("Using authenticated HTTPS proxy [%s:%s]", proxyHost, proxyPort));
                    } else {
                        log.debug((Object)String.format("Using HTTPS proxy [%s:%s]", proxyHost, proxyPort));
                    }
                }
            } else {
                if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                    if (!StringUtils.hasText(secureSettings.getSecureProperty("es.net.proxy.http.pass"))) {
                        log.warn((Object)String.format("HTTP proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.http.pass"));
                    }
                    HttpState state = new HttpState();
                    state.setProxyCredentials(AuthScope.ANY, new UsernamePasswordCredentials(settings.getNetworkProxyHttpUser(), secureSettings.getSecureProperty("es.net.proxy.http.pass")));
                    results[1] = state;
                }
                if (log.isDebugEnabled()) {
                    if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                        log.debug((Object)String.format("Using authenticated HTTP proxy [%s:%s]", proxyHost, proxyPort));
                    } else {
                        log.debug((Object)String.format("Using HTTP proxy [%s:%s]", proxyHost, proxyPort));
                    }
                }
            }
        }
        return results;
    }

    private HostConfiguration setupSocksProxy(Settings settings, SecureSettings secureSettings, HostConfiguration hostConfig) {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUser = null;
        String proxyPass = null;
        if (settings.getNetworkHttpUseSystemProperties()) {
            proxyHost = System.getProperty("socksProxyHost");
            proxyPort = Integer.getInteger("socksProxyPort", -1);
            proxyUser = System.getProperty("java.net.socks.username");
            proxyPass = System.getProperty("java.net.socks.password");
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksHost())) {
            proxyHost = settings.getNetworkProxySocksHost();
        }
        if (settings.getNetworkProxySocksPort() > 0) {
            proxyPort = settings.getNetworkProxySocksPort();
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksUser())) {
            proxyUser = settings.getNetworkProxySocksUser();
        }
        if (StringUtils.hasText(secureSettings.getSecureProperty("es.net.proxy.socks.pass"))) {
            proxyPass = secureSettings.getSecureProperty("es.net.proxy.socks.pass");
        }
        if (StringUtils.hasText(proxyHost)) {
            log.warn((Object)"Connecting to Elasticsearch through SOCKS proxy is deprecated in 6.6.0 and will be removed in a later release.");
            this.isSecure = false;
            this.isProxied = true;
            this.proxyInfo = this.proxyInfo.concat(String.format("[SOCKS proxy %s:%s]", proxyHost, proxyPort));
            if (!StringUtils.hasText(proxyUser)) {
                log.warn((Object)String.format("SOCKS proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.socks.pass"));
            }
            if (log.isDebugEnabled()) {
                if (StringUtils.hasText(proxyUser)) {
                    log.debug((Object)String.format("Using authenticated SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                } else {
                    log.debug((Object)String.format("Using SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                }
            }
            String schema2 = this.sslEnabled ? "https" : "http";
            int port = this.sslEnabled ? 443 : 80;
            SocksSocketFactory socketFactory = new SocksSocketFactory(proxyHost, proxyPort, proxyUser, proxyPass);
            CommonsHttpTransport.replaceProtocol(socketFactory, schema2, port);
        }
        return hostConfig;
    }

    static void replaceProtocol(ProtocolSocketFactory socketFactory, String schema2, int defaultPort) {
        Protocol directHttp = Protocol.getProtocol(schema2);
        if (directHttp instanceof DelegatedProtocol) {
            directHttp = ((DelegatedProtocol)directHttp).getOriginal();
            assert (!(directHttp instanceof DelegatedProtocol));
        }
        DelegatedProtocol proxiedHttp = new DelegatedProtocol(socketFactory, directHttp, schema2, defaultPort);
        Protocol.registerProtocol(schema2, proxiedHttp);
    }

    @Override
    public Response execute(Request request) throws IOException {
        UserProvider executingProvider;
        ByteSequence ba;
        String path;
        HttpMethodBase http = null;
        switch (request.method()) {
            case DELETE: {
                http = new DeleteMethodWithBody();
                break;
            }
            case HEAD: {
                http = new HeadMethod();
                break;
            }
            case GET: {
                http = request.body() == null ? new GetMethod() : new GetMethodWithBody();
                break;
            }
            case POST: {
                http = new PostMethod();
                break;
            }
            case PUT: {
                http = new PutMethod();
                break;
            }
            default: {
                throw new EsHadoopTransportException("Unknown request method " + (Object)((Object)request.method()));
            }
        }
        CharSequence uri = request.uri();
        if (StringUtils.hasText(uri)) {
            if (String.valueOf(uri).contains("?")) {
                throw new EsHadoopInvalidRequest("URI has query portion on it: [" + uri + "]");
            }
            http.setURI(new URI(CommonsHttpTransport.escapeUri(uri.toString(), this.sslEnabled), false));
        }
        if ((path = this.pathPrefix + CommonsHttpTransport.addLeadingSlashIfNeeded(request.path().toString())).contains("?")) {
            throw new EsHadoopInvalidRequest("Path has query portion on it: [" + path + "]");
        }
        path = HttpEncodingTools.encodePath(path);
        http.setPath(path);
        try {
            uri = http.getURI().toString();
        }
        catch (URIException uriex) {
            throw new EsHadoopTransportException("Invalid target URI " + request, uriex);
        }
        CharSequence params2 = request.params();
        if (StringUtils.hasText(params2)) {
            http.setQueryString(params2.toString());
        }
        if ((ba = request.body()) != null && ba.length() > 0) {
            if (!(http instanceof EntityEnclosingMethod)) {
                throw new IllegalStateException(String.format("Method %s cannot contain body - implementation bug", request.method().name()));
            }
            EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)http;
            entityMethod.setRequestEntity(new BytesArrayRequestEntity(ba));
            entityMethod.setContentChunked(false);
        }
        this.headers.applyTo(http);
        if (this.runAsUser != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing request with runAs user set to [" + this.runAsUser + "]"));
            }
            http.addRequestHeader("es-security-runas-user", this.runAsUser);
        } else if (this.userProvider != null && this.userProvider.getUser().getEsToken(this.clusterName) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Performing preemptive authentication with API Token");
            }
            http.getHostAuthState().setPreemptive();
            http.getHostAuthState().setAuthAttempted(true);
            http.getHostAuthState().setAuthScheme(new EsApiKeyAuthScheme());
            if (this.isProxied && !this.isSecure) {
                http.getProxyAuthState().setPreemptive();
                http.getProxyAuthState().setAuthAttempted(true);
            }
        }
        if (this.proxyUserProvider != null) {
            log.debug((Object)"Using proxyUserProvider to wrap rest request");
            executingProvider = this.proxyUserProvider;
        } else if (this.userProvider != null) {
            log.debug((Object)"Using regular user provider to wrap rest request");
            executingProvider = this.userProvider;
        } else {
            log.debug((Object)"Skipping user provider request wrapping");
            executingProvider = null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Tx %s[%s]@[%s][%s]?[%s] w/ payload [%s]", this.proxyInfo, request.method().name(), this.httpInfo, request.path(), request.params(), request.body()));
        }
        if (executingProvider != null) {
            final HttpMethodBase method = http;
            executingProvider.getUser().doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    CommonsHttpTransport.this.doExecute(method);
                    return null;
                }
            });
        } else {
            this.doExecute(http);
        }
        if (log.isTraceEnabled()) {
            Socket sk = (Socket)ReflectionUtils.invoke(GET_SOCKET, this.conn, null);
            String addr = sk.getLocalAddress().getHostAddress();
            log.trace((Object)String.format("Rx %s@[%s] [%s-%s] [%s]", this.proxyInfo, addr, http.getStatusCode(), HttpStatus.getStatusText(http.getStatusCode()), http.getResponseBodyAsString()));
        }
        return new SimpleResponse(http.getStatusCode(), new ResponseInputStream(http), this.httpInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(HttpMethod method) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.client.executeMethod(method);
            this.afterExecute(method);
        }
        finally {
            this.stats.netTotalTime += System.currentTimeMillis() - start;
            this.closeAuthSchemeQuietly(method);
        }
    }

    private void afterExecute(HttpMethod method) throws IOException {
        AuthScheme authScheme;
        AuthState hostAuthState = method.getHostAuthState();
        if ((hostAuthState.isPreemptive() || hostAuthState.isAuthAttempted()) && (authScheme = hostAuthState.getAuthScheme()) instanceof SpnegoAuthScheme && this.settings.getNetworkSpnegoAuthMutual()) {
            String id;
            SpnegoAuthScheme spnegoAuthScheme = (SpnegoAuthScheme)authScheme;
            Map challenges = AuthChallengeParser.parseChallenges(method.getResponseHeaders(WWW_AUTHENTICATE));
            String challenge = (String)challenges.get((id = spnegoAuthScheme.getSchemeName()).toLowerCase());
            if (challenge == null) {
                throw new IOException(id + " authorization challenge expected, but not found");
            }
            spnegoAuthScheme.ensureMutualAuth(challenge);
        }
    }

    private void closeAuthSchemeQuietly(HttpMethod method) {
        AuthScheme scheme = method.getHostAuthState().getAuthScheme();
        if (scheme instanceof Closeable) {
            try {
                ((Closeable)((Object)scheme)).close();
            }
            catch (IOException e) {
                log.error((Object)("Could not close [" + scheme.getSchemeName() + "] auth scheme"), (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        HttpConnectionManager manager;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Closing HTTP transport to " + this.httpInfo));
        }
        if ((manager = this.client.getHttpConnectionManager()) instanceof SocketTrackingConnectionManager) {
            try {
                ((SocketTrackingConnectionManager)manager).close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception ex) {
                log.warn((Object)"Exception closing underlying HTTP manager", (Throwable)ex);
            }
        }
    }

    private static String escapeUri(String uri, boolean ssl) {
        String escaped = HttpEncodingTools.encodeUri(uri);
        return escaped.contains("://") ? escaped : (ssl ? "https://" : "http://") + escaped;
    }

    private static String addLeadingSlashIfNeeded(String string) {
        return string.startsWith("/") ? string : "/" + string;
    }

    @Override
    public Stats stats() {
        return this.stats;
    }

    static {
        ReflectionUtils.makeAccessible(GET_SOCKET);
    }

    private class SocketTrackingConnectionManager
    extends SimpleHttpConnectionManager {
        private SocketTrackingConnectionManager() {
        }

        @Override
        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
            CommonsHttpTransport.this.conn = super.getConnectionWithTimeout(hostConfiguration, timeout);
            return CommonsHttpTransport.this.conn;
        }

        public void close() {
            if (this.httpConnection != null) {
                if (this.httpConnection.isOpen()) {
                    this.releaseConnection(this.httpConnection);
                }
                this.httpConnection.close();
            }
            this.httpConnection = null;
            CommonsHttpTransport.this.conn = null;
        }
    }

    private static class ResponseInputStream
    extends DelegatingInputStream
    implements ReusableInputStream {
        private final HttpMethod method;
        private final boolean reusable;

        public ResponseInputStream(HttpMethod http) throws IOException {
            super(http.getResponseBodyAsStream());
            this.method = http;
            this.reusable = this.delegate() instanceof ByteArrayInputStream;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public InputStream copy() {
            try {
                return this.reusable ? this.method.getResponseBodyAsStream() : null;
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isNull()) {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.method.releaseConnection();
        }
    }
}

