/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.query.BoolQueryBuilder;
import org.elasticsearch.hadoop.rest.query.MatchAllQueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.rest.query.SimpleQueryParser;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.regex.Regex;

public abstract class QueryUtils {
    public static QueryBuilder parseQuery(Settings settings) {
        String query = settings.getQuery();
        if (!StringUtils.hasText(query)) {
            return MatchAllQueryBuilder.MATCH_ALL;
        }
        if (!(query = query.trim()).startsWith("?") && !query.startsWith("{")) {
            try {
                InputStream in = settings.loadResource(query);
                if (in == null) {
                    throw new IOException();
                }
                query = IOUtils.asString(in);
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot determine specified query - doesn't appear to be URI or JSON based and location [%s] cannot be opened", query));
            }
        }
        try {
            return SimpleQueryParser.parse(query, true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse query: " + query, e);
        }
    }

    public static List<QueryBuilder> parseFilters(Settings settings) {
        String[] rawFilters = SettingsUtils.getFilters(settings);
        if (rawFilters == null) {
            return Collections.emptyList();
        }
        ArrayList<QueryBuilder> filters = new ArrayList<QueryBuilder>();
        for (String filter : rawFilters) {
            filter = filter.trim();
            try {
                filters.add(SimpleQueryParser.parse(filter, false));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse filter: " + filter, e);
            }
        }
        return filters;
    }

    public static QueryBuilder parseQueryAndFilters(Settings settings) {
        QueryBuilder query = QueryUtils.parseQuery(settings);
        List<QueryBuilder> filters = QueryUtils.parseFilters(settings);
        if (filters == null || filters.isEmpty()) {
            return query;
        }
        return new BoolQueryBuilder().must(query).filters(filters);
    }

    public static boolean isExplicitlyRequested(String candidate, String ... indices) {
        boolean result = false;
        for (String indexOrAlias : indices) {
            boolean include = true;
            if (indexOrAlias.charAt(0) == '+' || indexOrAlias.charAt(0) == '-') {
                include = indexOrAlias.charAt(0) == '+';
                indexOrAlias = indexOrAlias.substring(1);
            }
            if (indexOrAlias.equals("*") || indexOrAlias.equals("_all")) {
                return false;
            }
            if (Regex.isSimpleMatchPattern(indexOrAlias)) {
                if (!Regex.simpleMatch(indexOrAlias, candidate)) continue;
                if (include) {
                    result = true;
                    continue;
                }
                return false;
            }
            if (!candidate.equals(indexOrAlias)) continue;
            if (include) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }
}

