/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.hadoop.serialization.json.BackportedJacksonMappingIterator;
import org.elasticsearch.hadoop.serialization.json.ObjectReader;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonFactory;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonProcessingException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationConfig;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationContext;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializerProvider;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonMappingException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.deser.StdDeserializationContext;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.introspect.VisibilityChecker;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.type.TypeFactory;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ReflectionUtils;

public class BackportedObjectReader
implements ObjectReader {
    static final Field ROOT_DESERIALIZERS;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;
    protected final DeserializationConfig _config;
    protected final DeserializerProvider _provider;
    protected final JsonFactory _jsonFactory;
    protected TypeResolverBuilder<?> _defaultTyper;
    protected VisibilityChecker<?> _visibilityChecker;
    protected final JavaType _valueType;
    protected final Object _valueToUpdate;

    public static BackportedObjectReader create(ObjectMapper mapper, Class<?> type) {
        return new BackportedObjectReader(mapper, TypeFactory.type(type), null);
    }

    protected BackportedObjectReader(ObjectMapper mapper, JavaType valueType, Object valueToUpdate) {
        this._rootDeserializers = (ConcurrentHashMap)ReflectionUtils.getField(ROOT_DESERIALIZERS, mapper);
        this._provider = mapper.getDeserializerProvider();
        this._jsonFactory = mapper.getJsonFactory();
        this._config = mapper.copyDeserializationConfig();
        this._valueType = valueType;
        this._valueToUpdate = valueToUpdate;
        if (valueToUpdate != null && valueType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
    }

    public <T> BackportedJacksonMappingIterator<T> readValues(JsonParser jp) throws IOException, JsonProcessingException {
        DeserializationContext ctxt = this._createDeserializationContext(jp, this._config);
        return new BackportedJacksonMappingIterator(this._valueType, jp, ctxt, this._findRootDeserializer(this._config, this._valueType));
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationConfig cfg, JavaType valueType) throws JsonMappingException {
        if (valueType == null) {
            throw new JsonMappingException("No value type configured for ObjectReader");
        }
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser != null) {
            return deser;
        }
        deser = this._provider.findTypedValueDeserializer(cfg, valueType);
        if (deser == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + valueType);
        }
        this._rootDeserializers.put(valueType, deser);
        return deser;
    }

    protected DeserializationContext _createDeserializationContext(JsonParser jp, DeserializationConfig cfg) {
        return new StdDeserializationContext(cfg, jp, this._provider);
    }

    static {
        Field fl = ReflectionUtils.findField(ObjectMapper.class, "_rootDeserializers");
        Assert.notNull(fl, "Cannot find root deserializers");
        ROOT_DESERIALIZERS = fl;
        ReflectionUtils.makeAccessible(fl);
    }
}

