/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ErrorOnUnknown;
import org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context>
implements BiFunction<XContentParser, Context, Value>,
ContextParser<Context, Value> {
    private final List<String[]> requiredFieldSets = new ArrayList<String[]>();
    private final List<String[]> exclusiveFieldSets = new ArrayList<String[]>();
    private final Map<String, FieldParser> fieldParserMap = new HashMap<String, FieldParser>();
    private final String name;
    private final Function<Context, Value> valueBuilder;
    private final UnknownFieldParser<Value, Context> unknownFieldParser;

    public static <Value, ElementValue> BiConsumer<Value, List<ElementValue>> fromList(Class<ElementValue> c, BiConsumer<Value, ElementValue[]> consumer) {
        return (v, l) -> {
            Object[] array = (Object[])Array.newInstance(c, l.size());
            consumer.accept(v, l.toArray(array));
        };
    }

    private static <Value, Context> UnknownFieldParser<Value, Context> ignoreUnknown() {
        return (op, f, l, p, v, c) -> p.skipChildren();
    }

    private static <Value, Context> UnknownFieldParser<Value, Context> errorOnUnknown() {
        return (op, f, l, p, v, c) -> {
            throw new XContentParseException(l, ErrorOnUnknown.IMPLEMENTATION.errorMessage(op.name, f, op.fieldParserMap.keySet()));
        };
    }

    private static <Value, Context> UnknownFieldParser<Value, Context> consumeUnknownField(UnknownFieldConsumer<Value> consumer) {
        return (objectParser, field, location, parser, value, context) -> {
            XContentParser.Token t = parser.currentToken();
            switch (t) {
                case VALUE_STRING: {
                    consumer.accept(value, field, parser.text());
                    break;
                }
                case VALUE_NUMBER: {
                    consumer.accept(value, field, parser.numberValue());
                    break;
                }
                case VALUE_BOOLEAN: {
                    consumer.accept(value, field, parser.booleanValue());
                    break;
                }
                case VALUE_NULL: {
                    consumer.accept(value, field, null);
                    break;
                }
                case START_OBJECT: {
                    consumer.accept(value, field, parser.map());
                    break;
                }
                case START_ARRAY: {
                    consumer.accept(value, field, parser.list());
                    break;
                }
                default: {
                    throw new XContentParseException(parser.getTokenLocation(), "[" + objectParser.name + "] cannot parse field [" + field + "] with value type [" + (Object)((Object)t) + "]");
                }
            }
        };
    }

    private static <Value, Category, Context> UnknownFieldParser<Value, Context> unknownIsNamedXContent(Class<Category> categoryClass, BiConsumer<Value, ? super Category> consumer) {
        return (objectParser, field, location, parser, value, context) -> {
            Object o;
            try {
                o = parser.namedObject(categoryClass, field, context);
            }
            catch (NamedObjectNotFoundException e) {
                HashSet<String> candidates = new HashSet<String>(objectParser.fieldParserMap.keySet());
                e.getCandidates().forEach(candidates::add);
                String message = ErrorOnUnknown.IMPLEMENTATION.errorMessage(objectParser.name, field, candidates);
                throw new XContentParseException(location, message, e);
            }
            consumer.accept((Object)value, (Object)o);
        };
    }

    public ObjectParser(String name) {
        this(name, ObjectParser.errorOnUnknown(), null);
    }

    public ObjectParser(String name, @Nullable Supplier<Value> valueSupplier) {
        this(name, ObjectParser.errorOnUnknown(), (Context c) -> valueSupplier.get());
    }

    public static <Value, Context> ObjectParser<Value, Context> fromBuilder(String name, Function<Context, Value> valueBuilder) {
        Objects.requireNonNull(valueBuilder, "Use the single argument ctor instead");
        return new ObjectParser<Value, Context>(name, ObjectParser.errorOnUnknown(), valueBuilder);
    }

    public ObjectParser(String name, boolean ignoreUnknownFields, @Nullable Supplier<Value> valueSupplier) {
        this(name, ignoreUnknownFields ? ObjectParser.ignoreUnknown() : ObjectParser.errorOnUnknown(), (Context c) -> valueSupplier.get());
    }

    public ObjectParser(String name, UnknownFieldConsumer<Value> unknownFieldConsumer, @Nullable Supplier<Value> valueSupplier) {
        this(name, ObjectParser.consumeUnknownField(unknownFieldConsumer), (Context c) -> valueSupplier.get());
    }

    public <C> ObjectParser(String name, Class<C> categoryClass, BiConsumer<Value, C> unknownFieldConsumer, @Nullable Supplier<Value> valueSupplier) {
        this(name, ObjectParser.unknownIsNamedXContent(categoryClass, unknownFieldConsumer), (Context c) -> valueSupplier.get());
    }

    private ObjectParser(String name, UnknownFieldParser<Value, Context> unknownFieldParser, @Nullable Function<Context, Value> valueBuilder) {
        this.name = name;
        this.unknownFieldParser = unknownFieldParser;
        this.valueBuilder = valueBuilder;
    }

    @Override
    public Value parse(XContentParser parser, Context context) throws IOException {
        if (this.valueBuilder == null) {
            throw new NullPointerException("valueBuilder is not set");
        }
        return this.parse(parser, this.valueBuilder.apply(context), context);
    }

    public Value parse(XContentParser parser, Value value, Context context) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            token = parser.currentToken();
        } else {
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new XContentParseException(parser.getTokenLocation(), "[" + this.name + "] Expected START_OBJECT but was: " + (Object)((Object)token));
            }
        }
        FieldParser fieldParser = null;
        String currentFieldName = null;
        XContentLocation currentPosition = null;
        ArrayList<String[]> requiredFields = new ArrayList<String[]>(this.requiredFieldSets);
        ArrayList exclusiveFields = new ArrayList();
        for (int i = 0; i < this.exclusiveFieldSets.size(); ++i) {
            exclusiveFields.add(new ArrayList());
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                currentPosition = parser.getTokenLocation();
                fieldParser = this.fieldParserMap.get(currentFieldName);
                continue;
            }
            if (currentFieldName == null) {
                throw new XContentParseException(parser.getTokenLocation(), "[" + this.name + "] no field found");
            }
            if (fieldParser == null) {
                this.unknownFieldParser.acceptUnknownField(this, currentFieldName, currentPosition, parser, value, context);
            } else {
                fieldParser.assertSupports(this.name, parser, currentFieldName);
                Iterator iter = requiredFields.iterator();
                block2: while (iter.hasNext()) {
                    String[] requriedFields;
                    for (String field : requriedFields = (String[])iter.next()) {
                        if (!field.equals(currentFieldName)) continue;
                        iter.remove();
                        continue block2;
                    }
                }
                for (int i = 0; i < this.exclusiveFieldSets.size(); ++i) {
                    for (String field : this.exclusiveFieldSets.get(i)) {
                        if (!field.equals(currentFieldName)) continue;
                        ((List)exclusiveFields.get(i)).add(currentFieldName);
                    }
                }
                this.parseSub(parser, fieldParser, currentFieldName, value, context);
            }
            fieldParser = null;
        }
        StringBuilder message = new StringBuilder();
        for (List list : exclusiveFields) {
            if (list.size() <= 1) continue;
            message.append("The following fields are not allowed together: ").append(list.toString()).append(" ");
        }
        if (message.length() > 0) {
            throw new IllegalArgumentException(message.toString());
        }
        if (!requiredFields.isEmpty()) {
            for (Object[] objectArray : requiredFields) {
                message.append("Required one of fields ").append(Arrays.toString(objectArray)).append(", but none were specified. ");
            }
            throw new IllegalArgumentException(message.toString());
        }
        return value;
    }

    @Override
    public Value apply(XContentParser parser, Context context) {
        try {
            return this.parse(parser, context);
        }
        catch (IOException e) {
            throw new XContentParseException(parser.getTokenLocation(), "[" + this.name + "] failed to parse object", e);
        }
    }

    public void declareField(Parser<Value, Context> p, ParseField parseField, ValueType type) {
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] is required");
        }
        FieldParser fieldParser = new FieldParser(p, type.supportedTokens(), parseField, type);
        for (String fieldValue : parseField.getAllNamesIncludedDeprecated()) {
            this.fieldParserMap.putIfAbsent(fieldValue, fieldParser);
        }
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, ContextParser<Context, T> parser, ParseField parseField, ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField((p, v, c) -> consumer.accept(v, parser.parse(p, c)), parseField, type);
    }

    public <T> void declareObjectOrDefault(BiConsumer<Value, T> consumer, BiFunction<XContentParser, Context, T> objectParser, Supplier<T> defaultValue, ParseField field) {
        this.declareField((p, v, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (p.booleanValue()) {
                    consumer.accept(v, defaultValue.get());
                }
            } else {
                consumer.accept(v, objectParser.apply(p, c));
            }
        }, field, ValueType.OBJECT_OR_BOOLEAN);
    }

    @Override
    public <T> void declareNamedObject(BiConsumer<Value, T> consumer, NamedObjectParser<T, Context> namedObjectParser, ParseField field) {
        BiFunction<XContentParser, Object, Object> objectParser = (p, c) -> {
            try {
                XContentParser.Token token = p.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String name = p.currentName();
                try {
                    Object namedObject = namedObjectParser.parse((XContentParser)p, (Object)c, name);
                    token = p.nextToken();
                    assert (token == XContentParser.Token.END_OBJECT);
                    return namedObject;
                }
                catch (Exception e) {
                    throw new XContentParseException(p.getTokenLocation(), "[" + field + "] failed to parse field [" + name + "]", e);
                }
            }
            catch (IOException e) {
                throw new XContentParseException(p.getTokenLocation(), "[" + field + "] error while parsing named object", e);
            }
        };
        this.declareField((p, v, c) -> consumer.accept(v, objectParser.apply(p, c)), field, ValueType.OBJECT);
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, NamedObjectParser<T, Context> namedObjectParser, Consumer<Value> orderedModeCallback, ParseField field) {
        BiFunction<XContentParser, Object, Object> objectParser = (p, c) -> {
            if (p.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new XContentParseException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field");
            }
            try {
                String name = p.currentName();
                try {
                    return namedObjectParser.parse((XContentParser)p, (Object)c, name);
                }
                catch (Exception e) {
                    throw new XContentParseException(p.getTokenLocation(), "[" + field + "] failed to parse field [" + name + "]", e);
                }
            }
            catch (IOException e) {
                throw new XContentParseException(p.getTokenLocation(), "[" + field + "] error while parsing", e);
            }
        };
        this.declareField((p, v, c) -> {
            ArrayList fields = new ArrayList();
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT) {
                    fields.add(objectParser.apply(p, c));
                }
            } else if (p.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token;
                orderedModeCallback.accept(v);
                while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new XContentParseException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field");
                    }
                    p.nextToken();
                    fields.add(objectParser.apply(p, c));
                    p.nextToken();
                    if (p.currentToken() == XContentParser.Token.END_OBJECT) continue;
                    throw new XContentParseException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field");
                }
            }
            consumer.accept(v, fields);
        }, field, ValueType.OBJECT_ARRAY);
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, NamedObjectParser<T, Context> namedObjectParser, ParseField field) {
        Consumer<Object> orderedModeCallback = v -> {
            throw new IllegalArgumentException("[" + field + "] doesn't support arrays. Use a single object with multiple fields.");
        };
        this.declareNamedObjects(consumer, namedObjectParser, orderedModeCallback, field);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void declareRequiredFieldSet(String ... requiredSet) {
        if (requiredSet.length == 0) {
            return;
        }
        this.requiredFieldSets.add(requiredSet);
    }

    @Override
    public void declareExclusiveFieldSet(String ... exclusiveSet) {
        if (exclusiveSet.length == 0) {
            return;
        }
        this.exclusiveFieldSets.add(exclusiveSet);
    }

    private void parseArray(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY) : "Token was: " + (Object)((Object)parser.currentToken());
        this.parseValue(parser, fieldParser, currentFieldName, value, context);
    }

    private void parseValue(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        try {
            fieldParser.parser.parse(parser, value, context);
        }
        catch (Exception ex) {
            throw new XContentParseException(parser.getTokenLocation(), "[" + this.name + "] failed to parse field [" + currentFieldName + "]", ex);
        }
    }

    private void parseSub(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case START_OBJECT: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
                if (parser.currentToken() == XContentParser.Token.END_OBJECT) break;
                throw new IllegalStateException("parser for [" + currentFieldName + "] did not end on END_OBJECT");
            }
            case START_ARRAY: {
                this.parseArray(parser, fieldParser, currentFieldName, value, context);
                if (parser.currentToken() == XContentParser.Token.END_ARRAY) break;
                throw new IllegalStateException("parser for [" + currentFieldName + "] did not end on END_ARRAY");
            }
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw new XContentParseException(parser.getTokenLocation(), "[" + this.name + "]" + (Object)((Object)token) + " is unexpected");
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_BOOLEAN: 
            case VALUE_EMBEDDED_OBJECT: 
            case VALUE_NULL: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
            }
        }
    }

    public String toString() {
        return "ObjectParser{name='" + this.name + '\'' + ", fields=" + this.fieldParserMap.values() + '}';
    }

    private static interface UnknownFieldParser<Value, Context> {
        public void acceptUnknownField(ObjectParser<Value, Context> var1, String var2, XContentLocation var3, XContentParser var4, Value var5, Context var6) throws IOException;
    }

    public static interface UnknownFieldConsumer<Value> {
        public void accept(Value var1, String var2, Object var3);
    }

    private class FieldParser {
        private final Parser<Value, Context> parser;
        private final EnumSet<XContentParser.Token> supportedTokens;
        private final ParseField parseField;
        private final ValueType type;

        FieldParser(Parser<Value, Context> parser, EnumSet<XContentParser.Token> supportedTokens, ParseField parseField, ValueType type) {
            this.parser = parser;
            this.supportedTokens = supportedTokens;
            this.parseField = parseField;
            this.type = type;
        }

        void assertSupports(String parserName, XContentParser parser, String currentFieldName) {
            if (!this.parseField.match(parserName, parser::getTokenLocation, currentFieldName, parser.getDeprecationHandler())) {
                throw new XContentParseException(parser.getTokenLocation(), "[" + parserName + "] parsefield doesn't accept: " + currentFieldName);
            }
            if (!this.supportedTokens.contains((Object)parser.currentToken())) {
                throw new XContentParseException(parser.getTokenLocation(), "[" + parserName + "] " + currentFieldName + " doesn't support values of type: " + (Object)((Object)parser.currentToken()));
            }
        }

        public String toString() {
            Object[] deprecatedNames = this.parseField.getDeprecatedNames();
            String allReplacedWith = this.parseField.getAllReplacedWith();
            String deprecated = "";
            if (deprecatedNames != null && deprecatedNames.length > 0) {
                deprecated = ", deprecated_names=" + Arrays.toString(deprecatedNames);
            }
            return "FieldParser{preferred_name=" + this.parseField.getPreferredName() + ", supportedTokens=" + this.supportedTokens + deprecated + (allReplacedWith == null ? "" : ", replaced_with=" + allReplacedWith) + ", type=" + this.type.name() + '}';
        }
    }

    public static enum ValueType {
        STRING(XContentParser.Token.VALUE_STRING, new XContentParser.Token[0]),
        STRING_OR_NULL(XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        FLOAT(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        FLOAT_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        DOUBLE(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        DOUBLE_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        LONG(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        LONG_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        INT(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        INT_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        BOOLEAN(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_STRING),
        BOOLEAN_OR_NULL(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        STRING_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_STRING),
        FLOAT_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        DOUBLE_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        LONG_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        INT_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        BOOLEAN_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_BOOLEAN),
        OBJECT(XContentParser.Token.START_OBJECT, new XContentParser.Token[0]),
        OBJECT_OR_NULL(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_NULL),
        OBJECT_ARRAY(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY),
        OBJECT_ARRAY_OR_NULL(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NULL),
        OBJECT_OR_BOOLEAN(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_BOOLEAN),
        OBJECT_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_STRING),
        OBJECT_OR_LONG(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_NUMBER),
        OBJECT_ARRAY_BOOLEAN_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_STRING),
        OBJECT_ARRAY_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_STRING),
        OBJECT_ARRAY_STRING_OR_NUMBER(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER),
        VALUE(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_NULL, XContentParser.Token.VALUE_EMBEDDED_OBJECT, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        VALUE_OBJECT_ARRAY(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_NULL, XContentParser.Token.VALUE_EMBEDDED_OBJECT, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY),
        VALUE_ARRAY(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_NULL, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.START_ARRAY);

        private final EnumSet<XContentParser.Token> tokens;

        private ValueType(XContentParser.Token first, XContentParser.Token ... rest) {
            this.tokens = EnumSet.of(first, rest);
        }

        public EnumSet<XContentParser.Token> supportedTokens() {
            return this.tokens;
        }
    }

    public static interface Parser<Value, Context> {
        public void parse(XContentParser var1, Value var2, Context var3) throws IOException;
    }

    @FunctionalInterface
    public static interface NamedObjectParser<T, Context> {
        public T parse(XContentParser var1, Context var2, String var3) throws IOException;
    }
}

