/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.rankeval.RankEvalSpec;

public class RankEvalRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private RankEvalSpec rankingEvaluationSpec;
    private IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
    private String[] indices = Strings.EMPTY_ARRAY;

    public RankEvalRequest(RankEvalSpec rankingEvaluationSpec, String[] indices) {
        this.rankingEvaluationSpec = Objects.requireNonNull(rankingEvaluationSpec, "ranking evaluation specification must not be null");
        this.indices(indices);
    }

    RankEvalRequest(StreamInput in) throws IOException {
        super.readFrom(in);
        this.rankingEvaluationSpec = new RankEvalSpec(in);
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        } else {
            int indicesSize = in.readInt();
            String[] indices = new String[indicesSize];
            for (int i = 0; i < indicesSize; ++i) {
                indices[i] = in.readString();
            }
        }
    }

    RankEvalRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = null;
        if (this.rankingEvaluationSpec == null) {
            e = new ActionRequestValidationException();
            e.addValidationError("missing ranking evaluation specification");
        }
        return e;
    }

    public RankEvalSpec getRankEvalSpec() {
        return this.rankingEvaluationSpec;
    }

    public void setRankEvalSpec(RankEvalSpec task) {
        this.rankingEvaluationSpec = task;
    }

    public RankEvalRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
    }

    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.rankingEvaluationSpec.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
        } else {
            out.writeInt(this.indices.length);
            for (String index : this.indices) {
                out.writeString(index);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RankEvalRequest that = (RankEvalRequest)((Object)o);
        return Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.rankingEvaluationSpec, that.rankingEvaluationSpec);
    }

    public int hashCode() {
        return Objects.hash(this.indicesOptions, Arrays.hashCode(this.indices), this.rankingEvaluationSpec);
    }
}

