/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedResponse;

public class HttpPipelinedRequest
implements ReferenceCounted {
    private final LastHttpContent last;
    private final int sequence;

    public HttpPipelinedRequest(LastHttpContent last, int sequence) {
        this.last = last;
        this.sequence = sequence;
    }

    public LastHttpContent last() {
        return this.last;
    }

    public HttpPipelinedResponse createHttpResponse(FullHttpResponse response, ChannelPromise promise) {
        return new HttpPipelinedResponse(response, promise, this.sequence);
    }

    public int refCnt() {
        return this.last.refCnt();
    }

    public ReferenceCounted retain() {
        this.last.retain();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.last.retain(increment);
        return this;
    }

    public ReferenceCounted touch() {
        this.last.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.last.touch(hint);
        return this;
    }

    public boolean release() {
        return this.last.release();
    }

    public boolean release(int decrement) {
        return this.last.release(decrement);
    }
}

